/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.IClusterable;
import org.apache.wicket.Resource;
import org.apache.wicket.SharedResources;
import org.apache.wicket.markup.html.PackageResource;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.watch.IModifiable;

public class ResourceReference
implements IClusterable {
    private static final long serialVersionUID = 2L;
    protected Locale locale;
    private final String name;
    private transient Resource resource;
    private final String scopeName;
    private String style;

    public ResourceReference(Class scope, String name) {
        this(scope, name, null, null);
    }

    public ResourceReference(Class scope, String name, Locale locale, String style) {
        this.scopeName = scope.getName();
        this.name = name;
        this.locale = locale;
        this.style = style;
    }

    public ResourceReference(String name) {
        this(Application.class, name);
    }

    public final void bind(Application application) {
        if (this.resource == null) {
            SharedResources sharedResources = application.getSharedResources();
            this.resource = sharedResources.get(this.getScope(), this.name, this.locale, this.style, true);
            if (this.resource == null) {
                this.resource = this.newResource();
                if (this.resource == null) {
                    this.resource = sharedResources.get(this.getScope(), this.name, this.locale, this.style, false);
                    if (this.resource == null) {
                        PackageResource packageResource = PackageResource.get(this.getScope(), this.name);
                        sharedResources.add(this.name, packageResource);
                    }
                }
                sharedResources.add(this.getScope(), this.name, this.locale, this.style, this.resource);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceReference) {
            ResourceReference that = (ResourceReference)obj;
            return Objects.equal(this.getScope().getName(), that.getScope().getName()) && Objects.equal(this.name, that.name) && Objects.equal(this.locale, that.locale) && Objects.equal(this.style, that.style);
        }
        return false;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final String getName() {
        return this.name;
    }

    public final Resource getResource() {
        return this.resource;
    }

    public final Class getScope() {
        return Classes.resolveClass(this.scopeName);
    }

    public final String getSharedResourceKey() {
        Application application = Application.get();
        this.bind(application);
        return application.getSharedResources().resourceKey(this.getScope(), this.name, this.locale, this.style);
    }

    public final String getStyle() {
        return this.style;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.scopeName != null ? this.scopeName.hashCode() : 0);
        result = 37 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 37 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 37 * result + (this.style != null ? this.style.hashCode() : 0);
        return result;
    }

    public final void invalidate() {
        this.resource = null;
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
        this.invalidate();
    }

    public final void setStyle(String style) {
        this.style = style;
        this.invalidate();
    }

    public String toString() {
        return "[ResourceReference name = " + this.name + ", scope = " + this.scopeName + ", locale = " + this.locale + ", style = " + this.style + "]";
    }

    protected Resource newResource() {
        PackageResource packageResource = PackageResource.get(this.getScope(), this.getName(), this.getLocale(), this.getStyle());
        if (packageResource == null) {
            throw new IllegalArgumentException("package resource [scope=" + this.getScope() + ",name=" + this.getName() + ",locale=" + this.getLocale() + "style=" + this.getStyle() + "] not found");
        }
        this.locale = packageResource.getLocale();
        return packageResource;
    }

    public Time lastModifiedTime() {
        Resource resource = this.getResource();
        if (resource instanceof IModifiable) {
            return ((IModifiable)((Object)resource)).lastModifiedTime();
        }
        return null;
    }
}

