/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MergedMarkup;
import org.apache.wicket.markup.RawMarkup;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;

public final class MarkupStream {
    private MarkupElement current;
    private int currentIndex = 0;
    private final Markup markup;

    public MarkupStream(Markup markup) {
        this.markup = markup;
        if (markup.size() > 0) {
            this.current = this.get(this.currentIndex);
        }
    }

    public boolean atCloseTag() {
        return this.atTag() && this.getTag().isClose();
    }

    public boolean atOpenCloseTag() {
        return this.atTag() && this.getTag().isOpenClose();
    }

    public boolean atOpenCloseTag(String componentId) {
        return this.atOpenCloseTag() && componentId.equals(this.getTag().getId());
    }

    public boolean atOpenTag() {
        return this.atTag() && this.getTag().isOpen();
    }

    public boolean atOpenTag(String id) {
        return this.atOpenTag() && id.equals(this.getTag().getId());
    }

    public boolean atTag() {
        return this.current instanceof ComponentTag;
    }

    public boolean equalTo(MarkupStream that) {
        while (this.hasMore()) {
            MarkupElement thisElement = this.get();
            MarkupElement thatElement = that.get();
            if (thisElement != null && thatElement != null ? !thisElement.equalTo(thatElement) : thisElement != null || thatElement != null) {
                return false;
            }
            this.next();
            that.next();
        }
        return !that.hasMore();
    }

    public final boolean equalMarkup(MarkupStream markupStream) {
        if (markupStream == null) {
            return false;
        }
        return this.markup == markupStream.markup;
    }

    public final int findComponentIndex(String path, String id) {
        return this.markup.findComponentIndex(path, id);
    }

    public MarkupElement get() {
        return this.current;
    }

    public MarkupElement get(int index) {
        return this.markup.get(index);
    }

    public final Class getContainerClass() {
        return this.markup.getMarkupResourceData().getResource().getMarkupClass();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public final String getEncoding() {
        return this.markup.getMarkupResourceData().getEncoding();
    }

    public IResourceStream getResource() {
        return this.markup.getMarkupResourceData().getResource();
    }

    public ComponentTag getTag() {
        if (this.current instanceof ComponentTag) {
            return (ComponentTag)this.current;
        }
        this.throwMarkupException("Tag expected");
        return null;
    }

    public final String getWicketNamespace() {
        return this.markup.getMarkupResourceData().getWicketNamespace();
    }

    public String getXmlDeclaration() {
        return this.markup.getMarkupResourceData().getXmlDeclaration();
    }

    public boolean hasMore() {
        return this.currentIndex < this.markup.size();
    }

    public final boolean isMergedMarkup() {
        return this.markup instanceof MergedMarkup;
    }

    public MarkupElement next() {
        if (++this.currentIndex < this.markup.size()) {
            this.current = this.get(this.currentIndex);
            return this.current;
        }
        return null;
    }

    public void setCurrentIndex(int currentIndex) {
        this.current = this.get(currentIndex);
        this.currentIndex = currentIndex;
    }

    public final void skipComponent() {
        ComponentTag startTag = this.getTag();
        if (startTag.isOpen()) {
            if (!startTag.hasNoCloseTag()) {
                this.next();
                this.skipToMatchingCloseTag(startTag);
            }
            this.next();
        } else if (startTag.isOpenClose()) {
            this.next();
        } else {
            this.throwMarkupException("Skip component called on bad markup element " + startTag);
        }
    }

    public void skipRawMarkup() {
        ComponentTag tag;
        while (this.current instanceof RawMarkup ? this.next() != null : this.current instanceof ComponentTag && !(this.current instanceof WicketTag) && ((tag = (ComponentTag)this.current).isAutoComponentTag() ? this.next() != null : tag.isClose() && tag.getOpenTag().isAutoComponentTag() && this.next() != null)) {
        }
    }

    public void skipUntil(String wicketTagName) {
        do {
            if (!(this.current instanceof WicketTag) || !((WicketTag)this.current).getName().equals(wicketTagName)) continue;
            return;
        } while (this.next() != null);
    }

    public void skipToMatchingCloseTag(ComponentTag openTag) {
        while (this.hasMore()) {
            if (this.get().closes(openTag)) {
                return;
            }
            this.next();
        }
        this.throwMarkupException("Expected close tag for " + openTag);
    }

    public void throwMarkupException(String message) {
        throw new MarkupException(this, message);
    }

    public String toHtmlDebugString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.markup.size(); ++i) {
            if (i == this.currentIndex) {
                buffer.append("<font color = \"red\">");
            }
            MarkupElement element = this.markup.get(i);
            buffer.append(((Object)Strings.escapeMarkup(element.toString(), true)).toString());
            if (i != this.currentIndex) continue;
            buffer.append("</font>");
        }
        return buffer.toString();
    }

    public String toString() {
        return "[markup = " + String.valueOf(this.markup) + ", index = " + this.currentIndex + ", current = " + (this.current == null ? "null" : this.current.toUserDebugString()) + "]";
    }
}

