/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.string.Strings;

public class CheckGroup
extends FormComponent
implements IOnChangeListener {
    private static final long serialVersionUID = 1L;

    public CheckGroup(String id) {
        super(id);
        this.setRenderBodyOnly(true);
    }

    public CheckGroup(String id, Collection collection) {
        this(id, new Model((Serializable)((Object)collection)));
    }

    public CheckGroup(String id, IModel model) {
        super(id, model);
        this.setRenderBodyOnly(true);
    }

    protected Object convertValue(String[] values) throws ConversionException {
        ArrayList<Object> collection = new ArrayList<Object>();
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                final String value = values[i];
                if (value == null) continue;
                Check checkbox = (Check)this.visitChildren(new Component.IVisitor(){

                    public Object component(Component component) {
                        Check check;
                        if (component instanceof Check && String.valueOf((check = (Check)component).getValue()).equals(value)) {
                            return check;
                        }
                        return CONTINUE_TRAVERSAL;
                    }
                });
                if (checkbox == null) {
                    throw new WicketRuntimeException("submitted http post value [" + Strings.join(",", values) + "] for CheckGroup component [" + this.getPath() + "] contains an illegal relative path " + "element [" + value + "] which does not point to a Check component. Due to this the CheckGroup component cannot resolve the selected Check component pointed to by the illegal value. A possible reason is that componment hierarchy changed between rendering and form submission.");
                }
                collection.add(checkbox.getModelObject());
            }
        }
        return collection;
    }

    public void updateModel() {
        Collection collection = (Collection)this.getModelObject();
        if (collection == null) {
            collection = (Collection)this.getConvertedInput();
            this.setModelObject(collection);
        } else {
            this.modelChanging();
            collection.clear();
            collection.addAll((Collection)this.getConvertedInput());
            this.modelChanged();
        }
    }

    protected final boolean supportsPersistence() {
        return false;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("disabled");
        tag.remove("name");
    }

    public final void onSelectionChanged() {
        this.convertInput();
        this.updateModel();
        this.onSelectionChanged((Collection)this.getModelObject());
    }

    protected void onSelectionChanged(Collection newSelection) {
    }

    protected boolean wantOnSelectionChangedNotifications() {
        return false;
    }

    protected boolean getStatelessHint() {
        if (this.wantOnSelectionChangedNotifications()) {
            return false;
        }
        return super.getStatelessHint();
    }
}

