/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;

public final class WicketRemoveTagHandler
extends AbstractMarkupFilter {
    public final MarkupElement nextTag() throws ParseException {
        ComponentTag closeTag;
        ComponentTag openTag = (ComponentTag)this.getParent().nextTag();
        if (openTag == null) {
            return openTag;
        }
        if (!(openTag instanceof WicketTag) || !((WicketTag)openTag).isRemoveTag()) {
            return openTag;
        }
        if (openTag.isOpenClose()) {
            throw new ParseException("Wicket remove tag must not be an open-close tag: " + openTag.toUserDebugString(), openTag.getPos());
        }
        while (null != (closeTag = (ComponentTag)this.getParent().nextTag())) {
            if (closeTag.getId() == null) continue;
            if (closeTag.closes(openTag)) {
                openTag.setIgnore(true);
                return openTag;
            }
            throw new ParseException("Markup remove regions must not contain Wicket component tags. tag: " + closeTag.toUserDebugString(), closeTag.getPos());
        }
        throw new ParseException("Did not find close tag for markup remove region. Open tag: " + openTag.toUserDebugString(), openTag.getPos());
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("remove");
    }
}

