/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.file;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.wicket.util.file.Files;
import org.apache.wicket.util.file.Folder;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.watch.IModifiable;

public class File
extends java.io.File
implements IModifiable {
    private static final long serialVersionUID = 1L;

    public File(File parent, String child) {
        super(parent, child);
    }

    public File(java.io.File parent, String child) {
        super(parent, child);
    }

    public File(java.io.File file) {
        super(file.getAbsolutePath());
    }

    public File(String pathname) {
        super(pathname);
    }

    public File(String parent, String child) {
        super(parent, child);
    }

    public File(URI uri) {
        super(uri);
    }

    public String getExtension() {
        int lastDot = this.getName().lastIndexOf(46);
        if (lastDot >= 0) {
            return this.getName().substring(lastDot + 1);
        }
        return null;
    }

    public Folder getParentFolder() {
        return new Folder(this.getParent());
    }

    public final Time lastModifiedTime() {
        return Time.milliseconds(this.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String readString() throws IOException {
        FileInputStream in = new FileInputStream(this);
        try {
            String string = Streams.readString(in);
            return string;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public boolean remove() {
        return Files.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws IOException {
        FileInputStream in = new FileInputStream(this);
        try {
            in.getFD().sync();
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            this.write(in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public final int write(InputStream input) throws IOException {
        return Files.writeTo(this, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(String string) throws IOException {
        FileWriter out = new FileWriter(this);
        try {
            out.write(string);
        }
        finally {
            out.close();
        }
    }
}

