/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDialect
extends SQLDialect {
    protected Integer POINT = new Integer(2001);
    protected Integer LINESTRING = new Integer(2002);
    protected Integer POLYGON = new Integer(2003);
    protected Integer MULTIPOINT = new Integer(2004);
    protected Integer MULTILINESTRING = new Integer(2005);
    protected Integer MULTIPOLYGON = new Integer(2006);
    protected Integer GEOMETRY = new Integer(2007);
    protected String storageEngine;

    public MySQLDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public void setStorageEngine(String storageEngine) {
        this.storageEngine = storageEngine;
    }

    public String getStorageEngine() {
        return this.storageEngine;
    }

    public String getNameEscape() {
        return "";
    }

    public String getGeometryTypeName(Integer type) {
        if (this.POINT.equals(type)) {
            return "POINT";
        }
        if (this.MULTIPOINT.equals(type)) {
            return "MULTIPOINT";
        }
        if (this.LINESTRING.equals(type)) {
            return "LINESTRING";
        }
        if (this.MULTILINESTRING.equals(type)) {
            return "MULTILINESTRING";
        }
        if (this.POLYGON.equals(type)) {
            return "POLYGON";
        }
        if (this.MULTIPOLYGON.equals(type)) {
            return "MULTIPOLYGON";
        }
        if (this.GEOMETRY.equals(type)) {
            return "GEOMETRY";
        }
        return super.getGeometryTypeName(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT srid(");
        this.encodeColumnName(columnName, sql);
        sql.append(") ");
        sql.append("FROM ");
        if (schemaName != null) {
            this.encodeTableName(schemaName, sql);
            sql.append(".");
        }
        this.encodeSchemaName(tableName, sql);
        sql.append(" WHERE ");
        this.encodeColumnName(columnName, sql);
        sql.append(" is not null LIMIT 1");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            ResultSet rs;
            block9: {
                Integer n;
                rs = st.executeQuery(sql.toString());
                try {
                    if (!rs.next()) break block9;
                    n = new Integer(rs.getInt(1));
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs);
                return n;
            }
            Integer n = null;
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, int srid, StringBuffer sql) {
        sql.append("asWKB(");
        this.encodeColumnName(gatt.getLocalName(), sql);
        sql.append(")");
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("asWKB(");
        sql.append("envelope(");
        this.encodeColumnName(geometryColumn, sql);
        sql.append("))");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        byte[] wkb = rs.getBytes(column);
        try {
            Polygon polygon = (Polygon)new WKBReader().read(wkb);
            return polygon.getEnvelopeInternal();
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb for envelope";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String name, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(name);
        if (bytes == null) {
            return null;
        }
        try {
            return new WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Point.class, this.POINT);
        mappings.put(LineString.class, this.LINESTRING);
        mappings.put(Polygon.class, this.POLYGON);
        mappings.put(MultiPoint.class, this.MULTIPOINT);
        mappings.put(MultiLineString.class, this.MULTILINESTRING);
        mappings.put(MultiPolygon.class, this.MULTIPOLYGON);
        mappings.put(Geometry.class, this.GEOMETRY);
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        super.registerSqlTypeToClassMappings(mappings);
        mappings.put(this.POINT, Point.class);
        mappings.put(this.LINESTRING, LineString.class);
        mappings.put(this.POLYGON, Polygon.class);
        mappings.put(this.MULTIPOINT, MultiPoint.class);
        mappings.put(this.MULTILINESTRING, MultiLineString.class);
        mappings.put(this.MULTIPOLYGON, MultiPolygon.class);
        mappings.put(this.GEOMETRY, Geometry.class);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("POINT", Point.class);
        mappings.put("LINESTRING", LineString.class);
        mappings.put("POLYGON", Polygon.class);
        mappings.put("MULTIPOINT", MultiPoint.class);
        mappings.put("MULTILINESTRING", MultiLineString.class);
        mappings.put("MULTIPOLYGON", MultiPolygon.class);
        mappings.put("GEOMETRY", Geometry.class);
        mappings.put("GEOMETRYCOLLETION", GeometryCollection.class);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        overrides.put(16, "BOOL");
    }

    public void encodePostCreateTable(String tableName, StringBuffer sql) {
        sql.append("ENGINE=" + this.storageEngine);
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        if (att instanceof GeometryDescriptor && !att.isNillable()) {
            sql.append(" NOT NULL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor) || ad.isNillable()) continue;
            GeometryDescriptor gd = (GeometryDescriptor)ad;
            StringBuffer sql = new StringBuffer("ALTER TABLE ");
            this.encodeTableName(featureType.getTypeName(), sql);
            sql.append(" ADD SPATIAL INDEX (");
            this.encodeColumnName(gd.getLocalName(), sql);
            sql.append(")");
            LOGGER.fine(sql.toString());
            Statement st = cx.createStatement();
            try {
                st.execute(sql.toString());
            }
            finally {
                this.dataStore.closeSafe(st);
            }
        }
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(column, sql);
        sql.append(" int AUTO_INCREMENT PRIMARY KEY");
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT last_insert_id()";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit > 0 && limit < Integer.MAX_VALUE) {
            if (offset > 0) {
                sql.append(" LIMIT " + offset + ", " + limit);
            } else {
                sql.append(" LIMIT " + limit);
            }
        } else if (offset > 0) {
            sql.append(" LIMIT " + offset + ", " + Long.MAX_VALUE);
        }
    }
}

