/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import net.opengis.wfs.GetGmlObjectType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.wfs.GetFeature;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geotools.data.DataAccess;
import org.geotools.data.GmlObjectStore;
import org.geotools.factory.Hints;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.GmlObjectId;

public class GetGmlObject {
    WFSInfo wfs;
    Catalog catalog;
    FilterFactory filterFactory;

    public GetGmlObject(WFSInfo wfs, Catalog catalog) {
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public Object run(GetGmlObjectType request) throws WFSException {
        GmlObjectId id = request.getGmlObjectId();
        Hints hints = new Hints();
        if (request.getTraverseXlinkDepth() != null) {
            Integer depth = GetFeature.traverseXlinkDepth(request.getTraverseXlinkDepth());
            hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)depth);
        }
        for (DataStoreInfo dsInfo : this.catalog.getDataStores()) {
            DataAccess ds;
            try {
                ds = dsInfo.getDataStore(null);
            }
            catch (IOException e) {
                throw new WFSException(e);
            }
            if (!(ds instanceof GmlObjectStore)) continue;
            try {
                Object obj = ((GmlObjectStore)ds).getGmlObject(id, hints);
                if (obj == null) continue;
                return obj;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        throw new WFSException("No such object: " + id);
    }
}

