/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wfs.DescribeFeatureTypeType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.wfs.kvp.WFSKvpRequestReader;
import org.xml.sax.helpers.NamespaceSupport;

public class DescribeFeatureTypeKvpRequestReader
extends WFSKvpRequestReader {
    private final Catalog catalog;

    public DescribeFeatureTypeKvpRequestReader(Catalog catalog) {
        super(DescribeFeatureTypeType.class);
        this.catalog = catalog;
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        DescribeFeatureTypeType describeFeatureType = (DescribeFeatureTypeType)(request = super.read(request, kvp, rawKvp));
        if (!describeFeatureType.isSetOutputFormat()) {
            if (describeFeatureType.getVersion().startsWith("1.1")) {
                describeFeatureType.setOutputFormat("text/xml; subtype=gml/3.1.1");
            } else {
                describeFeatureType.setOutputFormat("XMLSCHEMA");
            }
        }
        NamespaceSupport namespaces = null;
        if (kvp.containsKey("NAMESPACE")) {
            if (kvp.get("NAMESPACE") instanceof NamespaceSupport) {
                namespaces = (NamespaceSupport)kvp.get("namespace");
            } else {
                LOGGER.warning("There's a namespace parameter but it seems it wasn't parsed to a " + NamespaceSupport.class.getName() + ": " + kvp.get("namespace"));
            }
        }
        if (namespaces != null) {
            EList typeNames = describeFeatureType.getTypeName();
            ArrayList<QName> newList = new ArrayList<QName>(typeNames.size());
            for (QName name : typeNames) {
                String localPart = name.getLocalPart();
                String prefix = name.getPrefix();
                String namespaceURI = name.getNamespaceURI();
                if ("".equals(prefix)) {
                    namespaceURI = namespaces.getURI("");
                } else if ("".equals(namespaceURI) && namespaces.getURI(prefix) != null) {
                    namespaceURI = namespaces.getURI(prefix);
                }
                if (this.catalog.getNamespaceByURI(namespaceURI) != null) {
                    prefix = this.catalog.getNamespaceByURI(namespaceURI).getPrefix();
                }
                newList.add(new QName(namespaceURI, localPart, prefix));
            }
            describeFeatureType.getTypeName().clear();
            describeFeatureType.getTypeName().addAll(newList);
        }
        return request;
    }
}

