/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.xml.BindingWalkerFactory;
import org.geotools.xml.Configuration;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.geotools.xml.SchemaIndex;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;

public final class GMLAbstractFeatureTypeBinding
extends org.geotools.gml2.bindings.GMLAbstractFeatureTypeBinding {
    GeometryFactory geometryFactory;
    Catalog catalog;

    public GMLAbstractFeatureTypeBinding(FeatureTypeCache featureTypeCache, BindingWalkerFactory bwFactory, SchemaIndex schemaIndex, GeometryFactory geometryFactory, Catalog catalog, Configuration configuration) {
        super(featureTypeCache, bwFactory, schemaIndex, configuration);
        this.geometryFactory = geometryFactory;
        this.catalog = catalog;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(instance.getNamespace(), instance.getName());
        if (meta != null) {
            FeatureType featureType = meta.getFeatureType();
            for (PropertyDescriptor pd : featureType.getDescriptors()) {
                Node boundedByNode;
                if (!(pd instanceof AttributeDescriptor)) continue;
                AttributeDescriptor attributeType = (AttributeDescriptor)pd;
                String name = attributeType.getLocalName();
                Class type = attributeType.getType().getBinding();
                if (!"boundedBy".equals(name) || !((boundedByNode = node.getChild("boundedBy")).getValue() instanceof Envelope)) continue;
                Envelope bounds = (Envelope)boundedByNode.getValue();
                if (type.isAssignableFrom(Polygon.class)) {
                    Polygon polygon = this.polygon(bounds);
                    boundedByNode.setValue((Object)polygon);
                    continue;
                }
                if (!type.isAssignableFrom(MultiPolygon.class)) continue;
                MultiPolygon multiPolygon = this.geometryFactory.createMultiPolygon(new Polygon[]{this.polygon(bounds)});
                boundedByNode.setValue((Object)multiPolygon);
            }
        }
        return super.parse(instance, node, value);
    }

    Polygon polygon(Envelope bounds) {
        return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[]{new Coordinate(bounds.getMinX(), bounds.getMinY()), new Coordinate(bounds.getMinX(), bounds.getMaxY()), new Coordinate(bounds.getMaxX(), bounds.getMaxY()), new Coordinate(bounds.getMaxX(), bounds.getMinY()), new Coordinate(bounds.getMinX(), bounds.getMinY())}), null);
    }
}

