/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.wfs.WFSException;
import org.geotools.util.Version;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;

public class WfsXmlReader
extends XmlRequestReader {
    Configuration configuration;
    Catalog catalog;

    public WfsXmlReader(String element, Configuration configuration, Catalog catalog) {
        this(element, configuration, catalog, "wfs");
    }

    protected WfsXmlReader(String element, Configuration configuration, Catalog catalog, String serviceId) {
        super(new QName("http://www.opengis.net/wfs", element), new Version("1.0.0"), serviceId);
        this.configuration = configuration;
        this.catalog = catalog;
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        Boolean strict = (Boolean)kvp.get("strict");
        if (strict == null) {
            strict = Boolean.FALSE;
        }
        Parser parser = new Parser(this.configuration);
        List namespaces = this.catalog.getNamespaces();
        for (NamespaceInfo ns : namespaces) {
            parser.getNamespaces().declarePrefix(ns.getPrefix(), ns.getURI());
        }
        parser.setValidating(strict.booleanValue());
        Object parsed = parser.parse(reader);
        if (strict.booleanValue() && !parser.getValidationErrors().isEmpty()) {
            WFSException exception = new WFSException("Invalid request", "InvalidParameterValue");
            for (Exception error : parser.getValidationErrors()) {
                exception.getExceptionText().add(error.getLocalizedMessage());
            }
            throw exception;
        }
        return parsed;
    }
}

