/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.util.FastInputStream;
import com.sleepycat.util.FastOutputStream;
import com.sleepycat.util.RuntimeExceptionWrapper;
import com.sleepycat.util.UtfOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;

public class StoredClassCatalog
implements ClassCatalog {
    private static final byte REC_LAST_CLASS_ID = 0;
    private static final byte REC_CLASS_FORMAT = 1;
    private static final byte REC_CLASS_INFO = 2;
    private static final byte[] LAST_CLASS_ID_KEY = new byte[]{0};
    private Database db;
    private HashMap<String, ClassInfo> classMap;
    private HashMap<BigInteger, ObjectStreamClass> formatMap;
    private LockMode writeLockMode;
    private boolean cdbMode;
    private boolean txnMode;
    private static byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    public StoredClassCatalog(Database database) throws DatabaseException, IllegalArgumentException {
        this.db = database;
        DatabaseConfig dbConfig = this.db.getConfig();
        EnvironmentConfig envConfig = this.db.getEnvironment().getConfig();
        this.writeLockMode = DbCompat.getInitializeLocking(envConfig) || envConfig.getTransactional() ? LockMode.RMW : LockMode.DEFAULT;
        this.cdbMode = DbCompat.getInitializeCDB(envConfig);
        this.txnMode = dbConfig.getTransactional();
        if (!DbCompat.isTypeBtree(dbConfig)) {
            throw new IllegalArgumentException("The class catalog must be a BTREE database.");
        }
        if (DbCompat.getSortedDuplicates(dbConfig) || DbCompat.getUnsortedDuplicates(dbConfig)) {
            throw new IllegalArgumentException("The class catalog database must not allow duplicates.");
        }
        this.classMap = new HashMap();
        this.formatMap = new HashMap();
        DatabaseEntry key = new DatabaseEntry(LAST_CLASS_ID_KEY);
        DatabaseEntry data = new DatabaseEntry();
        if (dbConfig.getReadOnly()) {
            OperationStatus status = this.db.get(null, key, data, null);
            if (status != OperationStatus.SUCCESS) {
                throw DbCompat.unexpectedState("A read-only catalog database may not be empty");
            }
        } else {
            data.setData(new byte[1]);
            OperationStatus status = this.db.get(null, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                this.db.putNoOverwrite(null, key, data);
            }
        }
    }

    public synchronized void close() throws DatabaseException {
        if (this.db != null) {
            this.db.close();
        }
        this.db = null;
        this.formatMap = null;
        this.classMap = null;
    }

    public synchronized byte[] getClassID(ObjectStreamClass classFormat) throws DatabaseException, ClassNotFoundException {
        ClassInfo classInfo = this.getClassInfo(classFormat);
        return classInfo.getClassID();
    }

    public synchronized ObjectStreamClass getClassFormat(byte[] classID) throws DatabaseException, ClassNotFoundException {
        return this.getClassFormat(classID, new DatabaseEntry());
    }

    private ObjectStreamClass getClassFormat(byte[] classID, DatabaseEntry data) throws DatabaseException, ClassNotFoundException {
        BigInteger classIDObj = new BigInteger(classID);
        ObjectStreamClass classFormat = this.formatMap.get(classIDObj);
        if (classFormat == null) {
            byte[] keyBytes = new byte[classID.length + 1];
            keyBytes[0] = 1;
            System.arraycopy(classID, 0, keyBytes, 1, classID.length);
            DatabaseEntry key = new DatabaseEntry(keyBytes);
            OperationStatus status = this.db.get(null, key, data, LockMode.DEFAULT);
            if (status != OperationStatus.SUCCESS) {
                throw new ClassNotFoundException("Catalog class ID not found");
            }
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data.getData(), data.getOffset(), data.getSize()));
                classFormat = (ObjectStreamClass)ois.readObject();
            }
            catch (IOException e) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(e);
            }
            this.formatMap.put(classIDObj, classFormat);
        }
        return classFormat;
    }

    private ClassInfo getClassInfo(ObjectStreamClass classFormat) throws DatabaseException, ClassNotFoundException {
        String className = classFormat.getName();
        ClassInfo classInfo = this.classMap.get(className);
        if (classInfo != null) {
            return classInfo;
        }
        char[] nameChars = className.toCharArray();
        byte[] keyBytes = new byte[1 + UtfOps.getByteLength(nameChars)];
        keyBytes[0] = 2;
        UtfOps.charsToBytes(nameChars, 0, keyBytes, 1, nameChars.length);
        DatabaseEntry key = new DatabaseEntry(keyBytes);
        DatabaseEntry data = new DatabaseEntry();
        OperationStatus status = this.db.get(null, key, data, LockMode.DEFAULT);
        if (status != OperationStatus.SUCCESS) {
            if (EnvironmentImpl.IS_DALVIK) {
                try {
                    FastOutputStream fo = new FastOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(fo);
                    oos.writeObject(classFormat);
                    byte[] bytes = fo.toByteArray();
                    FastInputStream fi = new FastInputStream(bytes);
                    ObjectInputStream ois = new ObjectInputStream(fi);
                    classFormat = (ObjectStreamClass)ois.readObject();
                }
                catch (Exception e) {
                    throw RuntimeExceptionWrapper.wrapIfNeeded(e);
                }
            }
            classInfo = this.putClassInfo(new ClassInfo(), className, key, classFormat);
        } else {
            classInfo = new ClassInfo(data);
            DatabaseEntry formatData = new DatabaseEntry();
            ObjectStreamClass storedClassFormat = this.getClassFormat(classInfo.getClassID(), formatData);
            if (!StoredClassCatalog.areClassFormatsEqual(storedClassFormat, StoredClassCatalog.getBytes(formatData), classFormat)) {
                classInfo = this.putClassInfo(classInfo, className, key, classFormat);
            }
            classInfo.setClassFormat(classFormat);
            this.classMap.put(className, classInfo);
        }
        return classInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassInfo putClassInfo(ClassInfo classInfo, String className, DatabaseEntry classKey, ObjectStreamClass classFormat) throws DatabaseException {
        ClassInfo classInfo2;
        Transaction txn;
        block9: {
            CursorConfig cursorConfig = null;
            if (this.cdbMode) {
                cursorConfig = new CursorConfig();
                DbCompat.setWriteCursor(cursorConfig, true);
            }
            Cursor cursor = null;
            txn = null;
            try {
                DatabaseEntry data;
                DatabaseEntry key;
                OperationStatus status;
                if (this.txnMode) {
                    txn = this.db.getEnvironment().beginTransaction(null, null);
                }
                if ((status = (cursor = this.db.openCursor(txn, cursorConfig)).getSearchKey(key = new DatabaseEntry(LAST_CLASS_ID_KEY), data = new DatabaseEntry(), this.writeLockMode)) != OperationStatus.SUCCESS) {
                    throw DbCompat.unexpectedState("Class ID not initialized");
                }
                byte[] idBytes = StoredClassCatalog.getBytes(data);
                idBytes = StoredClassCatalog.incrementID(idBytes);
                data.setData(idBytes);
                cursor.put(key, data);
                byte[] keyBytes = new byte[1 + idBytes.length];
                keyBytes[0] = 1;
                System.arraycopy(idBytes, 0, keyBytes, 1, idBytes.length);
                key.setData(keyBytes);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(classFormat);
                }
                catch (IOException e) {
                    throw RuntimeExceptionWrapper.wrapIfNeeded(e);
                }
                data.setData(baos.toByteArray());
                cursor.put(key, data);
                classInfo.setClassID(idBytes);
                classInfo.toDbt(data);
                cursor.put(classKey, data);
                classInfo.setClassFormat(classFormat);
                this.classMap.put(className, classInfo);
                this.formatMap.put(new BigInteger(idBytes), classFormat);
                classInfo2 = classInfo;
                Object var17_17 = null;
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var17_18 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (txn == null) break block10;
                    txn.commit();
                }
                throw throwable;
            }
            cursor.close();
        }
        if (txn != null) {
            txn.commit();
        }
        return classInfo2;
    }

    private static byte[] incrementID(byte[] key) {
        BigInteger id = new BigInteger(key);
        id = id.add(BigInteger.valueOf(1L));
        return id.toByteArray();
    }

    private static boolean areClassFormatsEqual(ObjectStreamClass format1, byte[] format1Bytes, ObjectStreamClass format2) {
        try {
            if (format1Bytes == null) {
                format1Bytes = StoredClassCatalog.getObjectBytes(format1);
            }
            byte[] format2Bytes = StoredClassCatalog.getObjectBytes(format2);
            return Arrays.equals(format2Bytes, format1Bytes);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static byte[] getBytes(DatabaseEntry dbt) {
        byte[] b = dbt.getData();
        if (b == null) {
            return null;
        }
        if (dbt.getOffset() == 0 && b.length == dbt.getSize()) {
            return b;
        }
        int len = dbt.getSize();
        if (len == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] t = new byte[len];
        System.arraycopy(b, dbt.getOffset(), t, 0, t.length);
        return t;
    }

    private static byte[] getObjectBytes(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        return baos.toByteArray();
    }

    private static class ClassInfo
    implements Serializable {
        static final long serialVersionUID = 3845446969989650562L;
        private byte[] classID;
        private transient ObjectStreamClass classFormat;

        ClassInfo() {
        }

        ClassInfo(DatabaseEntry dbt) {
            byte[] data = dbt.getData();
            byte len = data[0];
            this.classID = new byte[len];
            System.arraycopy(data, 1, this.classID, 0, len);
        }

        void toDbt(DatabaseEntry dbt) {
            byte[] data = new byte[1 + this.classID.length];
            data[0] = (byte)this.classID.length;
            System.arraycopy(this.classID, 0, data, 1, this.classID.length);
            dbt.setData(data);
        }

        void setClassID(byte[] classID) {
            this.classID = classID;
        }

        byte[] getClassID() {
            return this.classID;
        }

        ObjectStreamClass getClassFormat() {
            return this.classFormat;
        }

        void setClassFormat(ObjectStreamClass classFormat) {
            this.classFormat = classFormat;
        }
    }
}

