/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEVersion
implements Comparable<JEVersion> {
    public static final JEVersion CURRENT_VERSION = new JEVersion(4, 1, 7, null);
    private final int majorNum;
    private final int minorNum;
    private final int patchNum;
    private final String name;

    private JEVersion(int majorNum, int minorNum, int patchNum, String name) {
        this.majorNum = majorNum;
        this.minorNum = minorNum;
        this.patchNum = patchNum;
        this.name = name;
    }

    public JEVersion(String version) {
        StringTokenizer st = new StringTokenizer(version, ".");
        this.majorNum = Integer.parseInt(st.nextToken());
        this.minorNum = Integer.parseInt(st.nextToken());
        this.patchNum = Integer.parseInt(st.nextToken());
        this.name = st.hasMoreTokens() ? st.nextToken() : null;
    }

    public String toString() {
        return this.getVersionString();
    }

    public int getMajor() {
        return this.majorNum;
    }

    public int getMinor() {
        return this.minorNum;
    }

    public int getPatch() {
        return this.patchNum;
    }

    public String getNumericVersionString() {
        StringBuffer version = new StringBuffer();
        version.append(this.majorNum).append(".");
        version.append(this.minorNum).append(".");
        version.append(this.patchNum);
        return version.toString();
    }

    public String getVersionString() {
        StringBuffer version = new StringBuffer();
        version.append(this.majorNum).append(".");
        version.append(this.minorNum).append(".");
        version.append(this.patchNum);
        if (this.name != null) {
            version.append(".");
            version.append(this.name);
        }
        return version.toString();
    }

    @Override
    public int compareTo(JEVersion comparedVersion) {
        int result = 0;
        if (this.majorNum == comparedVersion.getMajor()) {
            if (this.minorNum == comparedVersion.getMinor()) {
                if (this.patchNum > comparedVersion.getPatch()) {
                    result = 1;
                } else if (this.patchNum < comparedVersion.getPatch()) {
                    result = -1;
                }
            } else {
                result = this.minorNum > comparedVersion.getMinor() ? 1 : -1;
            }
        } else {
            result = this.majorNum > comparedVersion.getMajor() ? 1 : -1;
        }
        return result;
    }

    public boolean equals(Object o) {
        return o instanceof JEVersion && this.compareTo((JEVersion)o) == 0;
    }

    public int hashCode() {
        return this.majorNum * 1000 * 1000 + this.minorNum * 1000 + this.patchNum;
    }
}

