/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.utilint.IdentityHashMap;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

class DirtyINMap {
    private final EnvironmentImpl envImpl;
    private final SortedMap<Integer, Map<Long, Checkpointer.CheckpointReference>> levelMap;
    private int numEntries;
    private final Set<DatabaseId> mapLNsToFlush;
    private final Map<DatabaseImpl, Integer> highestFlushLevels;
    private CkptState ckptState;
    private boolean ckptFlushAll;
    private boolean ckptFlushExtraLevel;

    DirtyINMap(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.levelMap = new TreeMap<Integer, Map<Long, Checkpointer.CheckpointReference>>();
        this.numEntries = 0;
        this.mapLNsToFlush = new HashSet<DatabaseId>();
        this.highestFlushLevels = new IdentityHashMap<DatabaseImpl, Integer>();
        this.ckptState = CkptState.NONE;
    }

    synchronized boolean coordinateEvictionWithCheckpoint(IN target, IN parent) {
        DatabaseImpl db = target.getDatabase();
        if (this.ckptState == CkptState.DIRTY_MAP_INCOMPLETE && parent != null) {
            this.selectForCheckpoint(parent);
            this.saveMapLNsToFlush(parent);
        }
        if (db.isDeferredWriteMode()) {
            return true;
        }
        if (this.ckptState == CkptState.DIRTY_MAP_INCOMPLETE && parent != null) {
            return true;
        }
        return this.ckptState == CkptState.DIRTY_MAP_COMPLETE && target.getLevel() < this.getHighestFlushLevel(db);
    }

    synchronized void beginCheckpoint(boolean flushAll, boolean flushExtraLevel) {
        assert (this.levelMap.isEmpty());
        assert (this.mapLNsToFlush.isEmpty());
        assert (this.highestFlushLevels.isEmpty());
        assert (this.numEntries == 0);
        assert (this.ckptState == CkptState.NONE);
        this.ckptState = CkptState.DIRTY_MAP_INCOMPLETE;
        this.ckptFlushAll = flushAll;
        this.ckptFlushExtraLevel = flushExtraLevel;
    }

    synchronized void reset() {
        this.removeCostFromMemoryBudget();
        this.levelMap.clear();
        this.mapLNsToFlush.clear();
        this.highestFlushLevels.clear();
        this.numEntries = 0;
        this.ckptState = CkptState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectDirtyINsForCheckpoint() throws DatabaseException {
        assert (this.ckptState == CkptState.DIRTY_MAP_INCOMPLETE);
        INList inMemINs = this.envImpl.getInMemoryINs();
        inMemINs.memRecalcBegin();
        boolean completed = false;
        try {
            for (IN in : inMemINs) {
                Object var6_5;
                in.latchShared(CacheMode.UNCHANGED);
                try {
                    inMemINs.memRecalcIterate(in);
                    if (in.getDirty()) {
                        this.selectForCheckpoint(in);
                    }
                    this.saveMapLNsToFlush(in);
                    var6_5 = null;
                    in.releaseLatch();
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    in.releaseLatch();
                    throw throwable;
                }
                TestHookExecute.doHookIfSet(Checkpointer.examineINForCheckpointHook, in);
            }
            completed = true;
            Object var8_8 = null;
            inMemINs.memRecalcEnd(completed);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            inMemINs.memRecalcEnd(completed);
            throw throwable;
        }
        DirtyINMap dirtyINMap = this;
        synchronized (dirtyINMap) {
            DbTree dbTree = this.envImpl.getDbTree();
            for (DatabaseImpl db : this.highestFlushLevels.keySet()) {
                if (this.highestFlushLevels.get(db) != null) continue;
                this.highestFlushLevels.put(db, dbTree.getHighestLevel(db));
            }
            this.addCostToMemoryBudget();
            this.ckptState = CkptState.DIRTY_MAP_COMPLETE;
        }
    }

    private synchronized void selectForCheckpoint(IN in) {
        DatabaseImpl db = in.getDatabase();
        if (db.isTemporary()) {
            return;
        }
        Integer level = this.addIN(in, false);
        if (this.ckptFlushAll || db.isDurableDeferredWrite()) {
            if (!this.highestFlushLevels.containsKey(db)) {
                this.highestFlushLevels.put(db, null);
            }
        } else {
            Integer highestLevelSeen;
            int levelVal = level;
            if (this.ckptFlushExtraLevel) {
                if (in.isRoot()) {
                    if (!in.isDbRoot()) {
                        levelVal = 65537;
                    }
                } else {
                    ++levelVal;
                }
            }
            if ((highestLevelSeen = this.highestFlushLevels.get(db)) == null || levelVal > highestLevelSeen) {
                if (this.ckptFlushExtraLevel) {
                    level = levelVal;
                }
                this.highestFlushLevels.put(db, level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectDirtyINsForDbSync(DatabaseImpl dbImpl) throws DatabaseException {
        assert (this.ckptState == CkptState.NONE);
        DatabaseId dbId = dbImpl.getId();
        for (IN in : this.envImpl.getInMemoryINs()) {
            Object var6_5;
            if (!in.getDatabaseId().equals(dbId)) continue;
            in.latch(CacheMode.UNCHANGED);
            try {
                if (in.getDirty()) {
                    this.addIN(in, false);
                }
                var6_5 = null;
                in.releaseLatch();
            }
            catch (Throwable throwable) {
                var6_5 = null;
                in.releaseLatch();
                throw throwable;
            }
        }
        this.highestFlushLevels.put(dbImpl, this.envImpl.getDbTree().getHighestLevel(dbImpl));
        this.addCostToMemoryBudget();
    }

    synchronized int getHighestFlushLevel(DatabaseImpl db) {
        assert (this.ckptState != CkptState.DIRTY_MAP_INCOMPLETE);
        Integer val = this.highestFlushLevels.get(db);
        return val != null ? val : -1;
    }

    synchronized int getNumLevels() {
        return this.levelMap.size();
    }

    private synchronized void addCostToMemoryBudget() {
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        int cost = this.numEntries * MemoryBudget.CHECKPOINT_REFERENCE_SIZE;
        mb.updateAdminMemoryUsage(cost);
    }

    private synchronized void removeCostFromMemoryBudget() {
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        int cost = this.numEntries * MemoryBudget.CHECKPOINT_REFERENCE_SIZE;
        mb.updateAdminMemoryUsage(0 - cost);
    }

    synchronized Integer addIN(IN in, boolean updateMemoryBudget) {
        Map<Long, Checkpointer.CheckpointReference> nodeMap;
        Integer level = in.getLevel();
        if (this.levelMap.containsKey(level)) {
            nodeMap = (Map)this.levelMap.get(level);
        } else {
            nodeMap = new HashMap();
            this.levelMap.put(level, nodeMap);
        }
        nodeMap.put(in.getNodeId(), new Checkpointer.CheckpointReference(in.getDatabase().getId(), in.getNodeId(), in.containsDuplicates(), in.isDbRoot(), in.getMainTreeKey(), in.getDupTreeKey()));
        ++this.numEntries;
        if (updateMemoryBudget) {
            MemoryBudget mb = this.envImpl.getMemoryBudget();
            mb.updateAdminMemoryUsage(MemoryBudget.CHECKPOINT_REFERENCE_SIZE);
        }
        return level;
    }

    synchronized Integer getLowestLevelSet() {
        return this.levelMap.firstKey();
    }

    synchronized void removeLevel(Integer level) {
        this.levelMap.remove(level);
    }

    synchronized boolean containsNode(Integer level, Long nodeId) {
        Map nodeMap = (Map)this.levelMap.get(level);
        if (nodeMap != null) {
            return nodeMap.containsKey(nodeId);
        }
        return false;
    }

    synchronized Checkpointer.CheckpointReference removeNode(Integer level, Long nodeId) {
        Map nodeMap = (Map)this.levelMap.get(level);
        if (nodeMap != null) {
            return (Checkpointer.CheckpointReference)nodeMap.remove(nodeId);
        }
        return null;
    }

    synchronized Checkpointer.CheckpointReference removeNextNode(Integer level) {
        Iterator iter;
        Map nodeMap = (Map)this.levelMap.get(level);
        if (nodeMap != null && (iter = nodeMap.entrySet().iterator()).hasNext()) {
            Checkpointer.CheckpointReference ref = (Checkpointer.CheckpointReference)iter.next().getValue();
            iter.remove();
            return ref;
        }
        return null;
    }

    private synchronized void saveMapLNsToFlush(IN in) {
        if (in instanceof BIN && in.getDatabase().getId().equals(DbTree.ID_DB_ID)) {
            for (int i = 0; i < in.getNEntries(); ++i) {
                MapLN ln = (MapLN)in.getTarget(i);
                if (ln == null || !ln.getDatabase().isCheckpointNeeded()) continue;
                this.mapLNsToFlush.add(ln.getDatabase().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushMapLNs(long checkpointStart) throws DatabaseException {
        HashSet<DatabaseId> mapLNsCopy;
        DirtyINMap dirtyINMap = this;
        synchronized (dirtyINMap) {
            assert (this.ckptState != CkptState.DIRTY_MAP_INCOMPLETE);
            if (this.mapLNsToFlush.isEmpty()) {
                mapLNsCopy = null;
            } else {
                mapLNsCopy = new HashSet<DatabaseId>(this.mapLNsToFlush);
                this.mapLNsToFlush.clear();
            }
        }
        if (mapLNsCopy != null) {
            DbTree dbTree = this.envImpl.getDbTree();
            for (DatabaseId dbId : mapLNsCopy) {
                Object var9_8;
                DatabaseImpl db = dbTree.getDb(dbId);
                try {
                    if (db != null && !db.isDeleted() && db.isCheckpointNeeded()) {
                        dbTree.modifyDbRoot(db, checkpointStart, true);
                    }
                    var9_8 = null;
                    dbTree.releaseDb(db);
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    dbTree.releaseDb(db);
                    throw throwable;
                }
            }
        }
    }

    void flushRoot(long checkpointStart) throws DatabaseException {
        DbTree dbTree = this.envImpl.getDbTree();
        if (dbTree.getDb(DbTree.ID_DB_ID).isCheckpointNeeded() || dbTree.getDb(DbTree.NAME_DB_ID).isCheckpointNeeded()) {
            this.envImpl.logMapTreeRoot(checkpointStart);
        }
    }

    synchronized int getNumEntries() {
        return this.numEntries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CkptState {
        NONE,
        DIRTY_MAP_INCOMPLETE,
        DIRTY_MAP_COMPLETE;

    }
}

