/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.awt.RenderingHints;
import java.awt.image.SampleModel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.wcs.WCSInfo;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Interpolate;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.coverage.processing.operation.SelectSampleDimension;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.vfny.geoserver.wcs.WcsException;

public class WCSUtils {
    private static final Logger LOGGER = Logging.getLogger(WCSUtils.class);
    public static final String ELEVATION = "ELEVATION";
    public static final Hints LENIENT_HINT = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
    private static final SelectSampleDimension bandSelectFactory = new SelectSampleDimension();
    private static final Interpolate interpolateFactory = new Interpolate();
    private static final Resample resampleFactory = new Resample();
    private static final ParameterValueGroup bandSelectParams;
    private static final ParameterValueGroup interpolateParams;
    private static final ParameterValueGroup resampleParams;
    private static final Hints hints;

    public static GridCoverage2D resample(GridCoverage2D coverage, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, GridGeometry2D gridGeometry, Interpolation interpolation) throws WcsException {
        ParameterValueGroup param = resampleParams.clone();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("CoordinateReferenceSystem").setValue((Object)targetCRS);
        param.parameter("GridGeometry").setValue((Object)gridGeometry);
        param.parameter("InterpolationType").setValue((Object)interpolation);
        return (GridCoverage2D)resampleFactory.doOperation(param, hints);
    }

    public static GridCoverage2D interpolate(GridCoverage2D coverage, Interpolation interpolation) throws WcsException {
        if (interpolation != null) {
            ParameterValueGroup param = interpolateParams.clone();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("Type").setValue((Object)interpolation);
            return (GridCoverage2D)interpolateFactory.doOperation(param, hints);
        }
        return coverage;
    }

    public static Coverage bandSelect(Map params, GridCoverage coverage) throws WcsException {
        int numDimensions = coverage.getNumSampleDimensions();
        HashMap<String, Integer> dims = new HashMap<String, Integer>();
        ArrayList selectedBands = new ArrayList();
        for (int d = 0; d < numDimensions; ++d) {
            dims.put("band" + (d + 1), new Integer(d));
        }
        if (params != null && !params.isEmpty()) {
            for (String param : params.keySet()) {
                if (!param.equalsIgnoreCase("BAND")) continue;
                try {
                    String values = (String)params.get(param);
                    if (values.indexOf("/") > 0) {
                        String[] minMaxRes = values.split("/");
                        int min = (int)Math.round(Double.parseDouble(minMaxRes[0]));
                        int max = (int)Math.round(Double.parseDouble(minMaxRes[1]));
                        double res = minMaxRes.length > 2 ? Double.parseDouble(minMaxRes[2]) : 0.0;
                        for (int v = min; v <= max; ++v) {
                            String key = param.toLowerCase() + v;
                            if (!dims.containsKey(key)) continue;
                            selectedBands.add(dims.get(key));
                        }
                        continue;
                    }
                    String[] bands = values.split(",");
                    for (int v = 0; v < bands.length; ++v) {
                        String key = param.toLowerCase() + bands[v];
                        if (!dims.containsKey(key)) continue;
                        selectedBands.add(dims.get(key));
                    }
                    if (selectedBands.size() != 0) continue;
                    throw new Exception("WRONG PARAM VALUES.");
                }
                catch (Exception e) {
                    throw new WcsException("Band parameters incorrectly specified: " + e.getLocalizedMessage());
                }
            }
        }
        int length = selectedBands.size();
        int[] bands = new int[length];
        for (int b = 0; b < length; ++b) {
            bands[b] = (Integer)selectedBands.get(b);
        }
        return WCSUtils.bandSelect(coverage, bands);
    }

    public static Coverage bandSelect(GridCoverage coverage, int[] bands) {
        GridCoverage bandSelectedCoverage;
        if (bands != null && bands.length > 0) {
            ParameterValueGroup param = bandSelectParams.clone();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("SampleDimensions").setValue((Object)bands);
            bandSelectedCoverage = bandSelectFactory.doOperation(param, hints);
        } else {
            bandSelectedCoverage = coverage;
        }
        return bandSelectedCoverage;
    }

    public static void checkOutputLimits(WCSInfo info, GridEnvelope2D gridRange2D, SampleModel sampleModel) {
        long limit = info.getMaxOutputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long actual = WCSUtils.getCoverageSize(gridRange2D, sampleModel);
        if (actual > limit) {
            throw new WcsException("This request is trying to generate too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of bytes to be " + "written in the output is " + WCSUtils.formatBytes(actual));
        }
    }

    public static void checkInputLimits(WCSInfo info, GridCoverage2D coverage) {
        long limit = info.getMaxInputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long actual = WCSUtils.getCoverageSize(coverage.getGridGeometry().getGridRange2D(), coverage.getRenderedImage().getSampleModel());
        if (actual > limit) {
            throw new WcsException("This request is trying to read too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of " + "bytes to be read is " + WCSUtils.formatBytes(actual));
        }
    }

    static long getCoverageSize(GridEnvelope2D envelope, SampleModel sm) {
        long pixels = 1L;
        for (int i = 0; i < envelope.getDimension(); ++i) {
            pixels *= (long)envelope.getSpan(i);
        }
        long pixelSize = 0L;
        for (int i = 0; i < sm.getNumBands(); ++i) {
            pixelSize += (long)sm.getSampleSize(i);
        }
        return pixels * pixelSize / 8L;
    }

    public static void checkInputLimits(WCSInfo info, CoverageInfo meta, AbstractGridCoverage2DReader reader, GridGeometry2D gridGeometry) throws WcsException {
        long limit = info.getMaxInputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long actual = 0L;
        try {
            GeneralEnvelope requestedEnvelope = new GeneralEnvelope(gridGeometry.getEnvelope());
            CoordinateReferenceSystem requestCRS = requestedEnvelope.getCoordinateReferenceSystem();
            CoordinateReferenceSystem nativeCRS = reader.getCrs();
            if (!CRS.equalsIgnoreMetadata((Object)requestCRS, (Object)nativeCRS)) {
                requestedEnvelope = CRS.transform((MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)requestCRS, (CoordinateReferenceSystem)nativeCRS, (boolean)true), (Envelope)requestedEnvelope);
            }
            requestedEnvelope.intersect((Envelope)reader.getOriginalEnvelope());
            if (!requestedEnvelope.isEmpty()) {
                MathTransform crsToGrid = meta.getGrid().getGridToCRS().inverse();
                GeneralEnvelope requestedGrid = CRS.transform((MathTransform)crsToGrid, (Envelope)requestedEnvelope);
                double[] spans = new double[requestedGrid.getDimension()];
                double[] resolutions = new double[requestedGrid.getDimension()];
                for (int i = 0; i < spans.length; ++i) {
                    spans[i] = requestedGrid.getSpan(i);
                    resolutions[i] = requestedEnvelope.getSpan(i) / spans[i];
                }
                OverviewPolicy policy = info.getOverviewPolicy();
                double[] readResoutions = reader.getReadingResolutions(policy, resolutions);
                double[] baseResolutions = reader.getReadingResolutions(OverviewPolicy.IGNORE, resolutions);
                for (int i = 0; i < spans.length; ++i) {
                    int n = i;
                    spans[n] = spans[n] * (readResoutions[i] / baseResolutions[i]);
                }
                long pixels = 1L;
                for (int i = 0; i < requestedGrid.getDimension(); ++i) {
                    pixels = (long)((double)pixels * Math.ceil(requestedGrid.getSpan(i)));
                }
                long pixelSize = 0L;
                if (meta.getDimensions() != null) {
                    for (CoverageDimensionInfo dimension : meta.getDimensions()) {
                        int size = WCSUtils.guessSizeFromRange(dimension.getRange());
                        if (size == 0) {
                            LOGGER.log(Level.INFO, "Failed to guess the size of dimension " + dimension.getName() + ", skipping the pre-read check");
                            pixelSize = -1L;
                            break;
                        }
                        pixelSize += (long)size;
                    }
                }
                actual = pixels * pixelSize / 8L;
            }
        }
        catch (Throwable t) {
            throw new WcsException("An error occurred while checking serving limits", t);
        }
        if (actual < 0L) {
            LOGGER.log(Level.INFO, "Warning, we could not estimate the amount of bytes to be read from the coverage source for the current request");
        }
        if (actual > limit) {
            throw new WcsException("This request is trying to read too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of bytes " + "to be read is " + WCSUtils.formatBytes(actual));
        }
    }

    static int guessSizeFromRange(NumberRange range) {
        double min = range.getMinimum();
        double max = range.getMaximum();
        double diff = max - min;
        if (diff <= 255.0) {
            return 8;
        }
        if (diff <= 65535.0) {
            return 16;
        }
        if (diff <= 4.294967295E9) {
            return 32;
        }
        if (diff <= 3.4028234663852886E38) {
            return 32;
        }
        return 64;
    }

    static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return new DecimalFormat("#.##").format((double)bytes / 1024.0) + "KB";
        }
        return new DecimalFormat("#.##").format((double)bytes / 1024.0 / 1024.0) + "MB";
    }

    public static Hints getReaderHints(WCSInfo wcs) {
        Hints hints = new Hints();
        hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        if (wcs.getOverviewPolicy() == null) {
            hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.OVERVIEW_POLICY, (Object)OverviewPolicy.IGNORE));
        } else {
            hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.OVERVIEW_POLICY, (Object)wcs.getOverviewPolicy()));
        }
        hints.put((Object)Hints.DECIMATION_POLICY, (Object)(wcs.isSubsamplingEnabled() ? DecimationPolicy.ALLOW : DecimationPolicy.DISALLOW));
        return hints;
    }

    static {
        hints = new Hints();
        hints.add((RenderingHints)LENIENT_HINT);
        CoverageProcessor processor = CoverageProcessor.getInstance((Hints)LENIENT_HINT);
        bandSelectParams = processor.getOperation("SelectSampleDimension").getParameters();
        interpolateParams = processor.getOperation("Interpolate").getParameters();
        resampleParams = processor.getOperation("Resample").getParameters();
    }
}

