/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs;

import org.geoserver.config.GeoServerInfo;
import org.geoserver.platform.ServiceException;

public class WcsException
extends ServiceException {
    private static final long serialVersionUID = -6110652531274829497L;
    private static final String SE_XML = "application/vnd.ogc.se_xml";

    public WcsException(String message) {
        super(message);
    }

    public WcsException(Throwable e) {
        super(e);
    }

    public WcsException(String message, String locator) {
        super(message, locator);
    }

    public WcsException(String message, WcsExceptionCode code, String locator) {
        super(message, code.name(), locator);
    }

    public WcsException(String message, Throwable cause) {
        super(message, cause);
    }

    public WcsException(Throwable e, String preMessage, String locator) {
        super(e, preMessage, locator);
    }

    public String getMimeType(GeoServerInfo geoserver) {
        return "application/vnd.ogc.se_xml; charset=" + geoserver.getCharset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WcsExceptionCode {
        MissingParameterValue,
        InvalidParameterValue,
        NoApplicableCode,
        UnsupportedCombination,
        NotEnoughStorage,
        InvalidUpdateSequence,
        CurrentUpdateSequence;

    }
}

