/*
 * Decompiled with CFR 0.152.
 */
package simple.http.session;

import java.lang.reflect.Constructor;
import simple.http.session.DefaultStore;
import simple.http.session.Store;
import simple.util.net.Cookie;

final class StoreFactory {
    private Constructor factory = this.getConstructor();

    public Store getInstance(Cookie cookie) {
        Object[] list = new Object[]{cookie};
        if (this.factory == null) {
            return new DefaultStore(cookie);
        }
        try {
            return (Store)this.factory.newInstance(list);
        }
        catch (Exception e) {
            return new DefaultStore(cookie);
        }
    }

    private Constructor getConstructor() {
        String property = "simple.http.session.store";
        String className = System.getProperty(property);
        try {
            return this.getConstructor(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Constructor getConstructor(String className) throws Exception {
        return this.getConstructor(Class.forName(className, false, StoreFactory.class.getClassLoader()));
    }

    private Constructor getConstructor(Class type) throws Exception {
        Class[] types = new Class[]{Cookie.class};
        return type.getDeclaredConstructor(types);
    }
}

