/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.reference;

import java.util.Collection;
import java.util.Date;
import org.geotools.util.Utilities;
import org.opengis.temporal.OrdinalEra;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOrdinalEra
implements OrdinalEra {
    private InternationalString name;
    private Date beginning;
    private Date end;
    private Collection<OrdinalEra> composition;
    private DefaultOrdinalEra group;

    public DefaultOrdinalEra(InternationalString name, Date beginning, Date end) {
        if (!beginning.before(end)) {
            throw new IllegalArgumentException("The beginning date of the OrdinalEra must be less than (i.e. earlier than) the end date of this OrdinalEra.");
        }
        this.name = name;
        this.beginning = beginning;
        this.end = end;
    }

    public DefaultOrdinalEra(InternationalString name, Date beginning, Date end, Collection<OrdinalEra> composition) {
        this.name = name;
        this.beginning = beginning;
        this.end = end;
        for (OrdinalEra ordinalEra : composition) {
            ((DefaultOrdinalEra)ordinalEra).setGroup(this);
        }
    }

    public InternationalString getName() {
        return this.name;
    }

    public Date getBeginning() {
        return this.beginning;
    }

    public Date getEnd() {
        return this.end;
    }

    public Collection<OrdinalEra> getComposition() {
        return this.composition;
    }

    public void setName(InternationalString name) {
        this.name = name;
    }

    public void setBeginning(Date beginning) {
        this.beginning = beginning;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public DefaultOrdinalEra getGroup() {
        return this.group;
    }

    public void setGroup(DefaultOrdinalEra group) {
        this.group = group;
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultOrdinalEra) {
            DefaultOrdinalEra that = (DefaultOrdinalEra)object;
            return Utilities.equals((Object)this.beginning, (Object)that.beginning) && Utilities.equals((Object)this.end, (Object)that.end) && Utilities.equals(this.composition, that.composition) && Utilities.equals((Object)this.group, (Object)that.group) && Utilities.equals((Object)this.name, (Object)that.name);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.beginning != null ? this.beginning.hashCode() : 0);
        hash = 37 * hash + (this.end != null ? this.end.hashCode() : 0);
        hash = 37 * hash + (this.composition != null ? ((Object)this.composition).hashCode() : 0);
        hash = 37 * hash + (this.group != null ? this.group.hashCode() : 0);
        hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("OrdinalEra:").append('\n');
        if (this.name != null) {
            s.append("name:").append((CharSequence)this.name).append('\n');
        }
        if (this.beginning != null) {
            s.append("beginning:").append(this.beginning).append('\n');
        }
        if (this.end != null) {
            s.append("end:").append(this.end).append('\n');
        }
        if (this.composition != null) {
            s.append("composition:").append(this.composition).append('\n');
        }
        if (this.group != null) {
            s.append("group:").append(this.group).append('\n');
        }
        return s.toString();
    }
}

