/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.datasource.ManageableDataSource;

public abstract class JDBC2DataStore
extends JDBC1DataStore {
    protected DataSource dataSource;

    public JDBC2DataStore(DataSource dataSource, JDBCDataStoreConfig config) throws IOException {
        super(config);
        this.dataSource = dataSource;
    }

    protected Connection createConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    protected void finalize() throws Throwable {
        if (this.dataSource != null) {
            LOGGER.severe("There's code using JDBC based datastore and not disposing them. This may lead to temporary loss of database connections. Please make sure all data access code calls DataStore.dispose() before freeing all references to it");
            this.dispose();
        }
    }

    public void dispose() {
        if (this.dataSource != null && this.dataSource instanceof ManageableDataSource) {
            try {
                ManageableDataSource mds = (ManageableDataSource)this.dataSource;
                this.dataSource = null;
                mds.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.FINE, "Could not close dataSource", e);
            }
        }
    }
}

