/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;

public class JDBCTransactionState
implements Transaction.State {
    private Connection connection;

    public JDBCTransactionState(Connection connection) throws IOException {
        this.connection = connection;
    }

    public JDBCTransactionState(DataSource pool) throws IOException {
        try {
            this.connection = pool.getConnection();
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            this.connection = null;
            throw new DataSourceException("Transaction could not acquire connection", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setTransaction(Transaction transaction) {
        if (transaction == null && this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public void addAuthorization(String AuthID) throws IOException {
    }

    public void commit() throws IOException {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new DataSourceException("Transaction commit", e);
        }
    }

    public void rollback() throws IOException {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new DataSourceException("Transaction rollback", e);
        }
    }
}

