/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.fidmapper;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.fidmapper.AbstractFIDMapper;
import org.geotools.data.jdbc.fidmapper.TypedFIDMapper;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

public class MaxIncFIDMapper
extends AbstractFIDMapper {
    private static final long serialVersionUID = 5719859796485477701L;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.jdbc.fidmapper");

    public MaxIncFIDMapper(String tableName, String FIDColumn, int FIDColumnType) {
        this(null, tableName, FIDColumn, FIDColumnType, false);
    }

    public MaxIncFIDMapper(String tableSchemaName, String tableName, String FIDColumn, int FIDColumnType, boolean returnFIDColumnsAsAttributes) {
        super(tableSchemaName, tableName);
        this.returnFIDColumnsAsAttributes = returnFIDColumnsAsAttributes;
        this.setInfo(FIDColumn, FIDColumnType, 0, 0, false);
    }

    public String getID(Object[] attributes) {
        return String.valueOf(attributes[0]);
    }

    public Object[] getPKAttributes(String FID) {
        try {
            return new Object[]{new Long(Long.parseLong(FID))};
        }
        catch (NumberFormatException e) {
            return new Object[]{new Long(-1L)};
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypedFIDMapper)) {
            return false;
        }
        MaxIncFIDMapper other = (MaxIncFIDMapper)object;
        return other.getColumnName() == this.getColumnName() && other.getColumnType() == this.getColumnType() && other.returnFIDColumnsAsAttributes == this.returnFIDColumnsAsAttributes;
    }

    public String createID(Connection conn, SimpleFeature feature, Statement statement) throws IOException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("Select MAX(" + this.getColumnName() + ") from " + this.tableName);
            if (rs.next()) {
                long maxFid = rs.getLong(1);
                String string = String.valueOf(maxFid + 1L);
                return string;
            }
            try {
                throw new DataSourceException("Could not get MAX for " + this.tableName + "." + this.getColumnName() + ": No result returned from query");
            }
            catch (SQLException e) {
                throw new DataSourceException("An sql problem occurred. Are the table and the fid column there?", e);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "MaxIncFidMapper could not close statement:" + e, e);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, "MaxIncFidMapper could not close resultset:" + e, e);
                }
            }
        }
    }

    public boolean isValid(String fid) {
        try {
            Long.parseLong(fid, 10);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

