/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyFinder;

public class CompositePrimaryKeyFinder
extends PrimaryKeyFinder {
    List<PrimaryKeyFinder> finders;

    public CompositePrimaryKeyFinder(PrimaryKeyFinder ... finders) {
        this.finders = Arrays.asList(finders);
    }

    public PrimaryKey getPrimaryKey(JDBCDataStore store, String schema, String table, Connection cx) throws SQLException {
        for (PrimaryKeyFinder finder : this.finders) {
            PrimaryKey pk = finder.getPrimaryKey(store, schema, table, cx);
            if (pk == null) continue;
            return pk;
        }
        return null;
    }
}

