/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.io.WKBWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.data.postgis.PostgisPSFilterToSql;
import org.geotools.jdbc.ColumnMetadata;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostGISPSDialect
extends PreparedStatementSQLDialect {
    private PostGISDialect delegate;

    public PostGISPSDialect(JDBCDataStore store, PostGISDialect delegate) {
        super(store);
        this.delegate = delegate;
    }

    @Override
    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return this.delegate.includeTable(schemaName, tableName, cx);
    }

    @Override
    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        return this.delegate.decodeGeometryEnvelope(rs, column, cx);
    }

    @Override
    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.delegate.decodeGeometryValue(descriptor, rs, column, factory, cx);
    }

    @Override
    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.delegate.decodeGeometryValue(descriptor, rs, column, factory, cx);
    }

    @Override
    public void encodeGeometryColumn(GeometryDescriptor gatt, int srid, StringBuffer sql) {
        this.delegate.encodeGeometryColumn(gatt, srid, sql);
    }

    @Override
    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.delegate.encodeGeometryEnvelope(tableName, geometryColumn, sql);
    }

    @Override
    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.delegate.encodePrimaryKey(column, sql);
    }

    @Override
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getGeometrySRID(schemaName, tableName, columnName, cx);
    }

    @Override
    public String getGeometryTypeName(Integer type) {
        return this.delegate.getGeometryTypeName(type);
    }

    @Override
    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        return this.delegate.getMapping(columnMetaData, cx);
    }

    @Override
    public boolean lookupGeneratedValuesPostInsert() {
        return this.delegate.lookupGeneratedValuesPostInsert();
    }

    @Override
    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getNextAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    @Override
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getLastAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    @Override
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        return this.delegate.getNextSequenceValue(schemaName, sequenceName, cx);
    }

    @Override
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getSequenceForColumn(schemaName, tableName, columnName, cx);
    }

    public boolean isLooseBBOXEnabled() {
        return this.delegate.isLooseBBOXEnabled();
    }

    @Override
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        this.delegate.postCreateTable(schemaName, featureType, cx);
    }

    @Override
    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        this.delegate.registerClassToSqlMappings(mappings);
    }

    @Override
    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        this.delegate.registerSqlTypeNameToClassMappings(mappings);
    }

    @Override
    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        this.delegate.registerSqlTypeToSqlTypeNameOverrides(overrides);
    }

    @Override
    public void handleUserDefinedType(ResultSet columnMetaData, ColumnMetadata metadata, Connection cx) throws SQLException {
        this.delegate.handleUserDefinedType(columnMetaData, metadata, cx);
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.delegate.setLooseBBOXEnabled(looseBBOXEnabled);
    }

    @Override
    public void prepareGeometryValue(Geometry g, int srid, Class binding, StringBuffer sql) {
        if (g != null) {
            sql.append("GeomFromWKB(?, " + srid + ")");
        } else {
            sql.append("?");
        }
    }

    @Override
    public void setGeometryValue(Geometry g, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g != null) {
            if (g instanceof LinearRing) {
                g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
            }
            byte[] bytes = new WKBWriter().write(g);
            ps.setBytes(column, bytes);
        } else {
            ps.setNull(column, 1111, "Geometry");
        }
    }

    @Override
    public PreparedFilterToSQL createPreparedFilterToSQL() {
        PostgisPSFilterToSql fts = new PostgisPSFilterToSql(this);
        fts.setLooseBBOXEnabled(this.delegate.isLooseBBOXEnabled());
        return fts;
    }

    @Override
    public boolean isLimitOffsetSupported() {
        return this.delegate.isLimitOffsetSupported();
    }

    @Override
    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        this.delegate.applyLimitOffset(sql, limit, offset);
    }
}

