/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.ows.Capabilities;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.WMSRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSCapabilities
extends Capabilities {
    private WMSRequest request;
    private Layer layer;
    private List<Layer> layers;
    private String[] exceptions;

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public List<Layer> getLayerList() {
        if (this.layers == null) {
            this.layers = new ArrayList<Layer>();
            this.layers.add(this.layer);
            this.addChildrenRecursive(this.layers, this.layer);
        }
        return Collections.unmodifiableList(this.layers);
    }

    private void addChildrenRecursive(List<Layer> layers, Layer layer) {
        if (layer.getChildren() != null) {
            for (Layer child : layer.getChildren()) {
                layers.add(child);
                this.addChildrenRecursive(layers, child);
            }
        }
    }

    public WMSRequest getRequest() {
        return this.request;
    }

    public void setRequest(WMSRequest request) {
        this.request = request;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(String[] exceptions) {
        this.exceptions = exceptions;
    }
}

