/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web.demo;

import java.awt.Rectangle;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geotools.coverage.grid.GridEnvelope2D;

public class GridPanel
extends FormComponentPanel {
    Integer minX;
    Integer minY;
    Integer maxX;
    Integer maxY;

    public GridPanel(String id) {
        super(id);
        this.initComponents();
    }

    public GridPanel(String id, GridEnvelope2D e) {
        this(id, (IModel)new Model((Serializable)e));
    }

    public GridPanel(String id, IModel model) {
        super(id, model);
        this.initComponents();
    }

    void initComponents() {
        this.updateFields();
        this.add(new Component[]{new TextField("minX", (IModel)new PropertyModel((Object)this, "minX"))});
        this.add(new Component[]{new TextField("minY", (IModel)new PropertyModel((Object)this, "minY"))});
        this.add(new Component[]{new TextField("maxX", (IModel)new PropertyModel((Object)this, "maxX"))});
        this.add(new Component[]{new TextField("maxY", (IModel)new PropertyModel((Object)this, "maxY"))});
    }

    protected void onBeforeRender() {
        this.updateFields();
        super.onBeforeRender();
    }

    private void updateFields() {
        GridEnvelope2D e = (GridEnvelope2D)this.getModelObject();
        if (e != null) {
            this.minX = (int)e.getMinX();
            this.minY = (int)e.getMinY();
            this.maxX = (int)e.getMaxX();
            this.maxY = (int)e.getMaxY();
        }
    }

    public GridPanel setReadOnly(final boolean readOnly) {
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                component.setEnabled(!readOnly);
                return null;
            }
        });
        return this;
    }

    protected void convertInput() {
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                ((TextField)component).processInput();
                return null;
            }
        });
        if (this.minX != null && this.maxX != null && this.minY != null && this.maxX != null) {
            int width = this.maxX - this.minX;
            int height = this.maxY - this.minY;
            this.setConvertedInput(new GridEnvelope2D(new Rectangle(this.minX, this.minY, width, height)));
        } else {
            this.setConvertedInput(null);
        }
    }

    protected void onModelChanged() {
        this.updateFields();
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                ((TextField)component).clearInput();
                return CONTINUE_TRAVERSAL;
            }
        });
    }
}

