/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridAlignmentMismatchException;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.ResolutionMismatchException;
import org.geowebcache.grid.SRS;

public class GridSet {
    protected Grid[] gridLevels;
    protected double[] baseCoords;
    protected BoundingBox originalExtent;
    protected boolean yBaseToggle = false;
    protected boolean yCoordinateFirst = false;
    protected boolean scaleWarning = false;
    protected double metersPerUnit;
    protected double pixelSize;
    protected String name;
    protected SRS srs;
    protected int tileWidth;
    protected int tileHeight;

    protected GridSet() {
    }

    protected BoundingBox boundsFromIndex(long[] tileIndex) {
        Grid grid = this.gridLevels[(int)tileIndex[2]];
        double width = grid.resolution * (double)this.tileWidth;
        double height = grid.resolution * (double)this.tileHeight;
        long y = tileIndex[1];
        if (this.yBaseToggle) {
            y -= grid.extent[1];
        }
        BoundingBox tileBounds = new BoundingBox(this.baseCoords[0] + width * (double)tileIndex[0], this.baseCoords[1] + height * (double)y, this.baseCoords[0] + width * (double)(tileIndex[0] + 1L), this.baseCoords[1] + height * (double)(y + 1L));
        return tileBounds;
    }

    protected BoundingBox boundsFromRectangle(long[] rectangleExtent) {
        Grid grid = this.gridLevels[(int)rectangleExtent[4]];
        double width = grid.resolution * (double)this.tileWidth;
        double height = grid.resolution * (double)this.tileHeight;
        long bottomY = rectangleExtent[1];
        long topY = rectangleExtent[3];
        if (this.yBaseToggle) {
            bottomY -= grid.extent[1];
            topY -= grid.extent[1];
        }
        BoundingBox rectangleBounds = new BoundingBox(this.baseCoords[0] + width * (double)rectangleExtent[0], this.baseCoords[1] + height * (double)bottomY, this.baseCoords[0] + width * (double)(rectangleExtent[2] + 1L), this.baseCoords[1] + height * (double)(topY + 1L));
        return rectangleBounds;
    }

    protected long[] closestIndex(BoundingBox tileBounds) throws GridMismatchException {
        double wRes = tileBounds.getWidth() / (double)this.tileWidth;
        double bestError = Double.MAX_VALUE;
        int bestLevel = -1;
        double bestResolution = -1.0;
        int i = 0;
        while (i < this.gridLevels.length) {
            Grid grid = this.gridLevels[i];
            double error = Math.abs(wRes - grid.resolution);
            if (!(error < bestError)) break;
            bestError = error;
            bestResolution = grid.resolution;
            bestLevel = i++;
        }
        if (Math.abs(wRes - bestResolution) > 0.1 * wRes) {
            throw new ResolutionMismatchException(wRes, bestResolution);
        }
        return this.closestIndex(bestLevel, tileBounds);
    }

    protected long[] closestIndex(int level, BoundingBox tileBounds) throws GridAlignmentMismatchException {
        Grid grid = this.gridLevels[level];
        double width = grid.resolution * (double)this.tileWidth;
        double height = grid.resolution * (double)this.tileHeight;
        double x = (tileBounds.getMinX() - this.baseCoords[0]) / width;
        double y = (tileBounds.getMinY() - this.baseCoords[1]) / height;
        long posX = Math.round(x);
        long posY = Math.round(y);
        if (x - (double)posX > 0.1 || y - (double)posY > 0.1) {
            throw new GridAlignmentMismatchException(x, posX, y, posY);
        }
        if (this.yBaseToggle) {
            posY += grid.extent[1];
        }
        long[] ret = new long[]{posX, posY, level};
        return ret;
    }

    public long[] closestRectangle(BoundingBox rectangleBounds) {
        double rectWidth = rectangleBounds.getWidth();
        double rectHeight = rectangleBounds.getHeight();
        double bestError = Double.MAX_VALUE;
        int bestLevel = -1;
        for (int i = 0; i < this.gridLevels.length; ++i) {
            Grid grid = this.gridLevels[i];
            double countX = rectWidth / (grid.resolution * (double)this.tileWidth);
            double countY = rectHeight / (grid.resolution * (double)this.tileHeight);
            double error = Math.abs(countX - (double)Math.round(countX)) + Math.abs(countY - (double)Math.round(countY));
            if (error < bestError) {
                bestError = error;
                bestLevel = i;
                continue;
            }
            if (error >= bestError) break;
        }
        return this.closestRectangle(bestLevel, rectangleBounds);
    }

    protected long[] closestRectangle(int level, BoundingBox rectangeBounds) {
        Grid grid = this.gridLevels[level];
        double width = grid.resolution * (double)this.tileWidth;
        double height = grid.resolution * (double)this.tileHeight;
        long minX = (long)Math.floor((rectangeBounds.getMinX() - this.baseCoords[0]) / width);
        long minY = (long)Math.floor((rectangeBounds.getMinY() - this.baseCoords[1]) / height);
        long maxX = (long)Math.ceil((rectangeBounds.getMaxX() - this.baseCoords[0]) / width);
        long maxY = (long)Math.ceil((rectangeBounds.getMaxY() - this.baseCoords[1]) / height);
        if (this.yBaseToggle) {
            minY += grid.extent[1];
            maxY += grid.extent[1];
        }
        long[] ret = new long[]{minX, minY, maxX - 1L, maxY - 1L, level};
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GridSet)) {
            return false;
        }
        GridSet other = (GridSet)obj;
        if (this == other) {
            return true;
        }
        if (!other.srs.equals(this.srs)) {
            return false;
        }
        if (!other.name.equals(this.name)) {
            return false;
        }
        if (this.tileWidth != other.tileWidth || this.tileHeight != other.tileHeight) {
            return false;
        }
        if (this.gridLevels.length != other.gridLevels.length) {
            return false;
        }
        for (int i = 0; i < this.gridLevels.length; ++i) {
            if (this.gridLevels[i].equals(other.gridLevels[i])) continue;
            return false;
        }
        return this.yBaseToggle == other.yBaseToggle;
    }

    public BoundingBox getBounds() {
        int i;
        long[] extent = null;
        for (i = this.gridLevels.length - 1; i > 0 && ((extent = this.gridLevels[i].extent)[0] != 1L || extent[1] != 0L); --i) {
        }
        extent = this.gridLevels[i].extent;
        long[] ret = new long[]{0L, 0L, extent[0] - 1L, extent[1] - 1L, i};
        return this.boundsFromRectangle(ret);
    }

    public Grid[] getGrids() {
        return this.gridLevels;
    }

    public double[] getOrderedTopLeftCorner(int gridIndex) {
        double[] leftTop = new double[2];
        if (this.yBaseToggle) {
            leftTop[0] = this.baseCoords[0];
            leftTop[1] = this.baseCoords[1];
        } else {
            Grid grid = this.gridLevels[gridIndex];
            double dTileHeight = this.tileHeight;
            double dGridExtent = grid.extent[1];
            double top = this.baseCoords[1] + dTileHeight * grid.resolution * dGridExtent;
            if (Math.abs(top - (double)Math.round(top)) < top / 200.0) {
                top = Math.round(top);
            }
            leftTop[0] = this.baseCoords[0];
            leftTop[1] = top;
        }
        if (this.yCoordinateFirst) {
            double[] ret = new double[]{leftTop[1], leftTop[0]};
            return ret;
        }
        return leftTop;
    }

    public String getName() {
        return this.name;
    }

    public SRS getSRS() {
        return this.srs;
    }

    public boolean getScaleWarning() {
        return this.scaleWarning;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public String guessMapUnits() {
        if (113000.0 > this.metersPerUnit && this.metersPerUnit > 110000.0) {
            return "degrees";
        }
        if (1100.0 > this.metersPerUnit && this.metersPerUnit > 900.0) {
            return "kilometers";
        }
        if (1.1 > this.metersPerUnit && this.metersPerUnit > 0.9) {
            return "meters";
        }
        if (0.4 > this.metersPerUnit && this.metersPerUnit > 0.28) {
            return "feet";
        }
        if (0.03 > this.metersPerUnit && this.metersPerUnit > 0.02) {
            return "inches";
        }
        if (0.02 > this.metersPerUnit && this.metersPerUnit > 0.005) {
            return "centimeters";
        }
        if (0.002 > this.metersPerUnit && this.metersPerUnit > 5.0E-4) {
            return "millimeters";
        }
        return "unknown";
    }

    public boolean isTopLeftAligned() {
        return this.yBaseToggle;
    }
}

