/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.SRS;

public class GridSetFactory {
    private static Log log = LogFactory.getLog(GridSetFactory.class);
    static int DEFAULT_LEVELS = 31;
    static final double EPSG4326_TO_METERS = 111319.49079327358;
    static final double EPSG3857_TO_METERS = 1.0;

    private static GridSet baseGridSet(String name, SRS srs, int tileWidth, int tileHeight) {
        GridSet gridSet = new GridSet();
        gridSet.name = name;
        gridSet.srs = srs;
        gridSet.tileWidth = tileWidth;
        gridSet.tileHeight = tileHeight;
        return gridSet;
    }

    public static GridSet createGridSet(String name, SRS srs, BoundingBox extent, boolean alignTopLeft, double[] resolutions, double[] scaleDenoms, Double metersPerUnit, double pixelSize, String[] scaleNames, int tileWidth, int tileHeight, boolean yCoordinateFirst) {
        GridSet gridSet = GridSetFactory.baseGridSet(name, srs, tileWidth, tileHeight);
        gridSet.baseCoords = new double[2];
        gridSet.pixelSize = pixelSize;
        if (alignTopLeft) {
            gridSet.baseCoords[0] = extent.getMinX();
            gridSet.baseCoords[1] = extent.getMaxY();
            gridSet.yBaseToggle = true;
        } else {
            gridSet.baseCoords[0] = extent.getMinX();
            gridSet.baseCoords[1] = extent.getMinY();
        }
        gridSet.yCoordinateFirst = yCoordinateFirst;
        gridSet.originalExtent = extent;
        if (metersPerUnit == null) {
            if (srs.equals(SRS.getEPSG4326())) {
                gridSet.metersPerUnit = 111319.49079327358;
            } else if (srs.equals(SRS.getEPSG3857())) {
                gridSet.metersPerUnit = 1.0;
            } else {
                if (resolutions == null) {
                    log.warn((Object)("GridSet " + name + " was defined without metersPerUnit, assuming 1m/unit." + " All scales will be off if this is incorrect."));
                } else {
                    log.warn((Object)("GridSet " + name + " was defined without metersPerUnit. " + "Assuming 1m per SRS unit for WMTS scale output."));
                    gridSet.scaleWarning = true;
                }
                gridSet.metersPerUnit = 1.0;
            }
        } else {
            gridSet.metersPerUnit = metersPerUnit;
        }
        gridSet.gridLevels = resolutions == null ? new Grid[scaleDenoms.length] : new Grid[resolutions.length];
        for (int i = 0; i < gridSet.gridLevels.length; ++i) {
            Grid curGrid = new Grid();
            if (scaleDenoms != null) {
                curGrid.scaleDenom = scaleDenoms[i];
                curGrid.resolution = pixelSize * (scaleDenoms[i] / gridSet.metersPerUnit);
            } else {
                curGrid.resolution = resolutions[i];
                curGrid.scaleDenom = resolutions[i] * gridSet.metersPerUnit / 2.8E-4;
            }
            double mapUnitWidth = (double)tileWidth * curGrid.resolution;
            double mapUnitHeight = (double)tileHeight * curGrid.resolution;
            curGrid.extent[0] = (long)Math.ceil((extent.getWidth() - mapUnitWidth * 0.01) / mapUnitWidth);
            curGrid.extent[1] = (long)Math.ceil((extent.getHeight() - mapUnitHeight * 0.01) / mapUnitHeight);
            curGrid.name = scaleNames == null ? gridSet.name + ":" + i : scaleNames[i];
            gridSet.gridLevels[i] = curGrid;
        }
        return gridSet;
    }

    public static GridSet createGridSet(String name, SRS srs, BoundingBox extent, boolean alignTopLeft, int levels, Double metersPerUnit, double pixelSize, int tileWidth, int tileHeight, boolean yCoordinateFirst) {
        double roundedRatio;
        double relHeight;
        double[] resolutions = new double[levels];
        double relWidth = extent.getWidth() / (double)tileWidth;
        double ratio = relWidth / (relHeight = extent.getHeight() / (double)tileHeight);
        double ratioDiff = ratio - (roundedRatio = (double)Math.round(ratio));
        if (Math.abs(ratioDiff) < 0.025) {
            resolutions[0] = relWidth / roundedRatio;
        } else if (ratio < roundedRatio) {
            ratio = ratioDiff < 0.0 ? roundedRatio : roundedRatio + 1.0;
            relWidth += ratio * relHeight - relWidth;
            extent.setMaxX(relWidth * (double)tileWidth + extent.getMinX());
            resolutions[0] = extent.getWidth() / ratio / (double)tileWidth;
        } else {
            ratio = ratioDiff > 0.0 ? roundedRatio : roundedRatio + 1.0;
            relHeight += relWidth / ratio - relHeight;
            if (alignTopLeft) {
                extent.setMinY(extent.getMaxY() - relHeight * (double)tileHeight);
            } else {
                extent.setMaxY(relHeight * (double)tileHeight + extent.getMinY());
            }
            resolutions[0] = extent.getWidth() / ratio / (double)tileWidth;
        }
        for (int i = 1; i < levels; ++i) {
            resolutions[i] = resolutions[i - 1] / 2.0;
        }
        return GridSetFactory.createGridSet(name, srs, extent, alignTopLeft, resolutions, null, metersPerUnit, pixelSize, null, tileWidth, tileHeight, yCoordinateFirst);
    }
}

