/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.geowebcache.io.Resource;

public class FileResource
implements Resource {
    private final File file;

    public FileResource(File file) {
        this.file = file;
    }

    public long getSize() {
        if (this.file.exists()) {
            return this.file.length();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(WritableByteChannel target) throws IOException {
        FileChannel in = new FileInputStream(this.file).getChannel();
        try {
            long size = in.size();
            long written = 0L;
            while ((written += in.transferTo(written, size, target)) < size) {
            }
            long l = size;
            return l;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(ReadableByteChannel channel) throws IOException {
        FileChannel out = new FileOutputStream(this.file).getChannel();
        FileLock lock = out.lock();
        try {
            long read;
            int buffsize = 4096;
            long position = 0L;
            while ((read = out.transferFrom(channel, position, 4096L)) > 0L) {
                position += read;
            }
            long l = position;
            return l;
        }
        finally {
            out.close();
            lock.release();
        }
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }
}

