/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.media.jai.JAI;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.TranslateDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.ResourceImageInputStream;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeType;
import org.springframework.util.Assert;

public class MetaTile
implements TileResponseReceiver {
    private static Log log;
    private final RenderingHints no_cache = new RenderingHints(JAI.KEY_TILE_CACHE, null);
    private static final boolean NATIVE_JAI_AVAILABLE;
    protected RenderedImage metaTiledImage = null;
    protected int[] gutter = new int[4];
    protected final Rectangle[] tiles;
    protected long[] metaGridCov = null;
    protected long[][] tilesGridPositions = null;
    protected int metaX;
    protected int metaY;
    protected GridSubset gridSubset;
    protected long status = -1L;
    protected boolean error = false;
    protected String errorMessage;
    protected long expiresHeader = -1L;
    protected MimeType responseFormat;
    protected FormatModifier formatModifier;
    private int gutterConfig;
    private BoundingBox metaBbox;
    private int metaTileWidth;
    private int metaTileHeight;

    public MetaTile(GridSubset gridSubset, MimeType responseFormat, FormatModifier formatModifier, long[] tileGridPosition, int metaX, int metaY, Integer gutter) {
        this.gridSubset = gridSubset;
        this.responseFormat = responseFormat;
        this.formatModifier = formatModifier;
        this.metaX = metaX;
        this.metaY = metaY;
        this.gutterConfig = gutter == null ? 0 : gutter;
        this.metaGridCov = this.calculateMetaTileGridBounds(gridSubset.getCoverage((int)tileGridPosition[2]), tileGridPosition);
        this.tilesGridPositions = this.calculateTilesGridPositions();
        this.calculateEdgeGutter();
        int tileHeight = gridSubset.getTileHeight();
        int tileWidth = gridSubset.getTileWidth();
        this.tiles = this.createTiles(tileHeight, tileWidth);
    }

    protected void calculateEdgeGutter() {
        Arrays.fill(this.gutter, 0);
        long[] layerCov = this.gridSubset.getCoverage((int)this.metaGridCov[4]);
        this.metaBbox = this.gridSubset.boundsFromRectangle(this.metaGridCov);
        this.metaTileWidth = this.metaX * this.gridSubset.getTileWidth();
        this.metaTileHeight = this.metaY * this.gridSubset.getTileHeight();
        double widthRelDelta = (1.0 * (double)this.metaTileWidth + (double)this.gutterConfig) / (double)this.metaTileWidth - 1.0;
        double heightRelDelta = (1.0 * (double)this.metaTileHeight + (double)this.gutterConfig) / (double)this.metaTileHeight - 1.0;
        double coordWidth = this.metaBbox.getWidth();
        double coordHeight = this.metaBbox.getHeight();
        double coordWidthDelta = coordWidth * widthRelDelta;
        double coordHeightDelta = coordHeight * heightRelDelta;
        if (layerCov[0] < this.metaGridCov[0]) {
            this.metaTileWidth += this.gutterConfig;
            this.gutter[0] = this.gutterConfig;
            this.metaBbox.setMinX(this.metaBbox.getMinX() - coordWidthDelta);
        }
        if (layerCov[1] < this.metaGridCov[1]) {
            this.metaTileHeight += this.gutterConfig;
            this.gutter[1] = this.gutterConfig;
            this.metaBbox.setMinY(this.metaBbox.getMinY() - coordHeightDelta);
        }
        if (layerCov[2] > this.metaGridCov[2]) {
            this.metaTileWidth += this.gutterConfig;
            this.gutter[2] = this.gutterConfig;
            this.metaBbox.setMaxX(this.metaBbox.getMaxX() + coordWidthDelta);
        }
        if (layerCov[3] > this.metaGridCov[3]) {
            this.metaTileHeight += this.gutterConfig;
            this.gutter[3] = this.gutterConfig;
            this.metaBbox.setMaxY(this.metaBbox.getMaxY() + coordHeightDelta);
        }
    }

    public BoundingBox getMetaTileBounds() {
        return this.metaBbox;
    }

    public int getMetaTileWidth() {
        return this.metaTileWidth;
    }

    public int getMetaTileHeight() {
        return this.metaTileHeight;
    }

    public int getStatus() {
        return (int)this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean getError() {
        return this.error;
    }

    public void setError() {
        this.error = true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getExpiresHeader() {
        return this.expiresHeader;
    }

    public void setExpiresHeader(long seconds) {
        this.expiresHeader = seconds;
    }

    public void setImageBytes(Resource buffer) throws GeoWebCacheException {
        Assert.notNull((Object)buffer, (String)"WMSMetaTile.setImageBytes() received null");
        Assert.isTrue((buffer.getSize() > 0L ? 1 : 0) != 0, (String)"WMSMetaTile.setImageBytes() received empty contents");
        try {
            ResourceImageInputStream imgStream = new ResourceImageInputStream(((ByteArrayResource)buffer).getInputStream());
            BufferedImage metaTiledImage = ImageIO.read(imgStream);
            this.setImage(metaTiledImage);
        }
        catch (IOException ioe) {
            throw new GeoWebCacheException("WMSMetaTile.setImageBytes() failed on ImageIO.read(byte[" + buffer.getSize() + "])", ioe);
        }
        if (this.metaTiledImage == null) {
            throw new GeoWebCacheException("ImageIO.read(InputStream) returned null. Unable to read image.");
        }
    }

    public void setImage(RenderedImage metaTiledImage) {
        this.metaTiledImage = metaTiledImage;
    }

    private Rectangle[] createTiles(int tileHeight, int tileWidth) {
        int tileCount = this.metaX * this.metaY;
        Rectangle[] tiles = new Rectangle[tileCount];
        for (int y = 0; y < this.metaY; ++y) {
            for (int x = 0; x < this.metaX; ++x) {
                int i = x * tileWidth + this.gutter[0];
                int j = (this.metaY - 1 - y) * tileHeight + this.gutter[3];
                tiles[y * this.metaX + x] = new Rectangle(i, j, tileWidth, tileHeight);
            }
        }
        return tiles;
    }

    public RenderedImage createTile(int minX, int minY, int tileWidth, int tileHeight) {
        BufferedImage tile = null;
        boolean useJAI = true;
        if (!(this.metaTiledImage instanceof BufferedImage)) {
            useJAI = true;
        } else if (this.responseFormat.getMimeType().startsWith("image/jpeg")) {
            useJAI = NATIVE_JAI_AVAILABLE;
        }
        if (useJAI) {
            try {
                tile = CropDescriptor.create((RenderedImage)this.metaTiledImage, (Float)new Float(minX), (Float)new Float(minY), (Float)new Float(tileWidth), (Float)new Float(tileHeight), (RenderingHints)this.no_cache);
                tile = TranslateDescriptor.create((RenderedImage)tile, (Float)new Float(-1.0f * (float)minX), (Float)new Float(-1.0f * (float)minY), null, null);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)("Error cropping, image is " + this.metaTiledImage.getWidth() + "x" + this.metaTiledImage.getHeight() + ", requesting a " + tileWidth + "x" + tileHeight + " tile starting at " + minX + "," + minY + "."));
                log.error((Object)("Message from JAI: " + iae.getMessage()));
                iae.printStackTrace();
            }
        } else {
            try {
                tile = ((BufferedImage)this.metaTiledImage).getSubimage(minX, minY, tileWidth, tileHeight);
            }
            catch (RasterFormatException rfe) {
                log.error((Object)("RendereedImage.getSubimage(" + minX + "," + minY + "," + tileWidth + "," + tileHeight + ") threw exception:"));
                rfe.printStackTrace();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Thread: " + Thread.currentThread().getName() + "\n" + ((Object)tile).toString() + ", " + "Information from tile (width, height, minx, miny): " + tile.getWidth() + ", " + tile.getHeight() + ", " + tile.getMinX() + ", " + tile.getMinY() + "\n" + "Information set (width, height, minx, miny): " + new Float(tileWidth) + ", " + new Float(tileHeight) + ", " + new Float(minX) + ", " + new Float(minY)));
        }
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTileToStream(int tileIdx, Resource target) throws IOException {
        if (this.tiles == null) {
            return false;
        }
        String format = this.responseFormat.getInternalName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Thread: " + Thread.currentThread().getName() + " writing: " + tileIdx));
        }
        ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (this.formatModifier != null) {
            param = this.formatModifier.adjustImageWriteParam(param);
        }
        Rectangle tileRegion = this.tiles[tileIdx];
        RenderedImage tile = this.createTile(tileRegion.x, tileRegion.y, tileRegion.width, tileRegion.height);
        OutputStream outputStream = target.getOutputStream();
        MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(outputStream);
        writer.setOutput(imgOut);
        IIOImage image = new IIOImage(tile, null, null);
        try {
            writer.write(null, image, param);
        }
        finally {
            imgOut.close();
            writer.dispose();
        }
        return true;
    }

    public String debugString() {
        return " metaX: " + this.metaX + " metaY: " + this.metaY + " metaGridCov: " + Arrays.toString(this.metaGridCov);
    }

    private long[] calculateMetaTileGridBounds(long[] coverage, long[] tileIdx) {
        long[] metaGridCov;
        metaGridCov = new long[]{tileIdx[0] - tileIdx[0] % (long)this.metaX, tileIdx[1] - tileIdx[1] % (long)this.metaY, Math.min(metaGridCov[0] + (long)this.metaX - 1L, coverage[2]), Math.min(metaGridCov[1] + (long)this.metaY - 1L, coverage[3]), tileIdx[2]};
        this.metaX = (int)(metaGridCov[2] - metaGridCov[0] + 1L);
        this.metaY = (int)(metaGridCov[3] - metaGridCov[1] + 1L);
        return metaGridCov;
    }

    private long[][] calculateTilesGridPositions() {
        if (this.metaX < 0 || this.metaY < 0) {
            return null;
        }
        long[][] tilesGridPos = new long[this.metaX * this.metaY][3];
        for (int y = 0; y < this.metaY; ++y) {
            for (int x = 0; x < this.metaX; ++x) {
                int tile = y * this.metaX + x;
                tilesGridPos[tile][0] = this.metaGridCov[0] + (long)x;
                tilesGridPos[tile][1] = this.metaGridCov[1] + (long)y;
                tilesGridPos[tile][2] = this.metaGridCov[4];
            }
        }
        return tilesGridPos;
    }

    public long[] getMetaGridPos() {
        long[] gridPos = new long[]{this.metaGridCov[0], this.metaGridCov[1], this.metaGridCov[4]};
        return gridPos;
    }

    public long[] getMetaTileGridBounds() {
        return this.metaGridCov;
    }

    public long[][] getTilesGridPositions() {
        return this.tilesGridPositions;
    }

    public SRS getSRS() {
        return this.gridSubset.getSRS();
    }

    public MimeType getResponseFormat() {
        return this.responseFormat;
    }

    public MimeType getRequestFormat() {
        if (this.formatModifier == null) {
            return this.responseFormat;
        }
        return this.formatModifier.getRequestFormat();
    }

    static {
        boolean nativeJAIAvailable;
        log = LogFactory.getLog(MetaTile.class);
        try {
            Class<?> image = Class.forName("com.sun.medialib.mlib.Image");
            nativeJAIAvailable = (Boolean)image.getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            nativeJAIAvailable = false;
        }
        NATIVE_JAI_AVAILABLE = nativeJAIAvailable;
    }
}

