/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;
import org.geowebcache.io.ByteArrayResource;

public class ResourceImageInputStream
extends ImageInputStreamImpl {
    private ByteArrayResource.SeekableInputStream is;

    public ResourceImageInputStream(ByteArrayResource.SeekableInputStream res) throws IOException {
        this.is = res;
    }

    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int val = this.is.read();
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        this.bitOffset = 0;
        if (len == 0) {
            return 0;
        }
        int val = this.is.read(b, off, len);
        if (val != -1) {
            this.streamPos += (long)len;
        }
        return val;
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedMemory() {
        return true;
    }

    public long length() {
        return this.is.length();
    }

    public void seek(long pos) throws IOException {
        this.is.seek(pos);
        super.seek(pos);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.is = null;
    }
}

