/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileLayerDispatcher
implements DisposableBean {
    private static Log log = LogFactory.getLog(TileLayerDispatcher.class);
    private Map<String, TileLayer> configuredLayers = null;
    private List<Configuration> configs = null;
    private GridSetBroker gridSetBroker = null;
    private ServiceInformation serviceInformation = null;
    private ExecutorService configLoadService;
    private Future<Map<String, TileLayer>> configurationLoadTask;

    public TileLayerDispatcher(GridSetBroker gridSetBroker, List<Configuration> configs) {
        this(gridSetBroker, configs, 2);
    }

    public TileLayerDispatcher(GridSetBroker gridSetBroker, List<Configuration> configs, int loadDelay) {
        this.gridSetBroker = gridSetBroker;
        this.configs = configs;
        if (loadDelay > -1) {
            CustomizableThreadFactory tfac = new CustomizableThreadFactory("GWC Configuration loader thread-");
            tfac.setDaemon(true);
            this.configLoadService = Executors.newSingleThreadExecutor((ThreadFactory)tfac);
            ConfigurationLoader loader = new ConfigurationLoader(this, loadDelay);
            this.configurationLoadTask = this.configLoadService.submit(loader);
        } else {
            try {
                this.configuredLayers = new ConfigurationLoader(this, loadDelay).call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public TileLayer getTileLayer(String layerIdent) throws GeoWebCacheException {
        Map<String, TileLayer> layers = this.checkConfigurationLoaded();
        TileLayer layer = layers.get(layerIdent);
        if (layer == null) {
            throw new GeoWebCacheException("Thread " + Thread.currentThread().getId() + " Unknown layer " + layerIdent + ". Check the logfiles," + " it may not have loaded properly.");
        }
        return layer;
    }

    private Map<String, TileLayer> checkConfigurationLoaded() throws GeoWebCacheException {
        Map<String, TileLayer> layers = this.configuredLayers;
        if (layers == null) {
            try {
                this.configuredLayers = layers = this.configurationLoadTask.get();
            }
            catch (InterruptedException e) {
                throw new GeoWebCacheException(e);
            }
            catch (ExecutionException e) {
                throw new GeoWebCacheException(e);
            }
        }
        return layers;
    }

    public void reInit() throws GeoWebCacheException {
        this.checkConfigurationLoaded();
        this.configuredLayers = null;
        this.configurationLoadTask = this.configLoadService.submit(new ConfigurationLoader(this, 0));
    }

    public int getLayerCount() {
        return this.getLayers().size();
    }

    public Set<String> getLayerNames() {
        return new HashSet<String>(this.getLayers().keySet());
    }

    public List<TileLayer> getLayerList() {
        return new ArrayList<TileLayer>(this.getLayers().values());
    }

    private Map<String, TileLayer> getLayers() {
        Map<String, TileLayer> layers;
        try {
            layers = this.checkConfigurationLoaded();
        }
        catch (GeoWebCacheException e) {
            throw new IllegalStateException(e);
        }
        return layers;
    }

    private LinkedHashMap<String, TileLayer> initialize(boolean reload) {
        log.debug((Object)"Thread initLayers(), initializing");
        LinkedHashMap<String, TileLayer> newLayers = new LinkedHashMap<String, TileLayer>();
        Iterator<Configuration> configIter = this.configs.iterator();
        while (configIter.hasNext()) {
            List<TileLayer> configLayers = null;
            Configuration config = configIter.next();
            String configIdent = null;
            try {
                configIdent = config.getIdentifier();
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
            }
            if (configIdent == null) continue;
            try {
                configLayers = config.getTileLayers(reload);
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
                log.error((Object)("Failed to add layers from " + configIdent));
            }
            log.info((Object)("Adding layers from " + configIdent));
            if (configLayers != null && configLayers.size() > 0) {
                for (TileLayer layer : configLayers) {
                    if (layer == null) {
                        log.error((Object)"layer was null");
                        continue;
                    }
                    log.info((Object)("Adding: " + layer.getName()));
                    layer.initialize(this.gridSetBroker);
                    this.add(layer, newLayers);
                }
            } else {
                log.error((Object)("Configuration " + configIdent + " contained no layers."));
            }
            if (this.serviceInformation != null) continue;
            try {
                log.debug((Object)"Reading service information.");
                this.serviceInformation = config.getServiceInformation();
            }
            catch (GeoWebCacheException e) {
                log.error((Object)("Error reading service information from " + configIdent + ": " + e.getMessage()));
            }
        }
        return newLayers;
    }

    public ServiceInformation getServiceInformation() {
        return this.serviceInformation;
    }

    public synchronized void update(TileLayer layer) {
        Map<String, TileLayer> layers;
        try {
            layers = this.checkConfigurationLoaded();
        }
        catch (GeoWebCacheException e) {
            throw new IllegalStateException(e);
        }
        TileLayer oldLayer = layers.get(layer.getName());
        if (oldLayer != null) {
            oldLayer.acquireLayerLock();
            layers.remove(layer.getName());
            oldLayer.releaseLayerLock();
        }
        layers.put(layer.getName(), layer);
    }

    public synchronized void remove(String layerName) {
        Map<String, TileLayer> layers;
        try {
            layers = this.checkConfigurationLoaded();
        }
        catch (GeoWebCacheException e) {
            throw new IllegalStateException(e);
        }
        TileLayer layer = layers.get(layerName);
        if (layer != null) {
            layer.acquireLayerLock();
            layers.remove(layerName);
            layer.releaseLayerLock();
        }
    }

    public void add(TileLayer layer) {
        Map<String, TileLayer> layers;
        try {
            layers = this.checkConfigurationLoaded();
        }
        catch (GeoWebCacheException e) {
            throw new IllegalStateException(e);
        }
        this.add(layer, layers);
    }

    private void add(TileLayer layer, Map<String, TileLayer> layerMap) {
        if (layerMap.containsKey(layer.getName())) {
            try {
                layerMap.get(layer.getName()).mergeWith(layer);
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
            }
        } else {
            layerMap.put(layer.getName(), layer);
        }
    }

    public void destroy() throws Exception {
        if (this.configLoadService != null) {
            log.info((Object)"Shutting down config load service thread...");
            this.configLoadService.shutdownNow();
            int timeout = 10;
            boolean terminated = this.configLoadService.awaitTermination(timeout, TimeUnit.SECONDS);
            if (terminated) {
                log.info((Object)"Config load service shut down.");
            } else {
                log.warn((Object)("Config load service didn't terminate after " + timeout + " seconds. This may prevent the server container to properly shut down!!!"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigurationLoader
    implements Callable<Map<String, TileLayer>> {
        TileLayerDispatcher parent;
        int loadDelay;

        private ConfigurationLoader(TileLayerDispatcher parent, int loadDelay) {
            this.parent = parent;
            this.loadDelay = loadDelay;
        }

        @Override
        public Map<String, TileLayer> call() throws Exception {
            if (this.loadDelay > 0) {
                log.info((Object)("ConfigurationLoader acquired lock, sleeping " + this.loadDelay + " seconds"));
                try {
                    Thread.sleep(this.loadDelay * 1000);
                    log.info((Object)"ConfigurationLoader woke up, initializing");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Configuration loader thread interrupted", e);
                }
            }
            LinkedHashMap newLayers = this.parent.initialize(false);
            log.info((Object)"ConfigurationLoader completed");
            return newLayers;
        }
    }
}

