/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import javax.imageio.ImageWriteParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;

public class FormatModifier {
    private static Log log = LogFactory.getLog(FormatModifier.class);
    private String requestFormat;
    private String responseFormat;
    private transient MimeType reqFormat;
    private transient MimeType resFormat;
    private Boolean transparent;
    private String bgColor;
    private String palette;
    private String compressionQuality;
    private transient Float compressQual;
    private transient ImageWriteParam imgWriteParam;

    public synchronized MimeType getRequestFormat() {
        if (this.requestFormat == null) {
            return this.getResponseFormat();
        }
        if (this.reqFormat == null) {
            try {
                this.reqFormat = MimeType.createFromFormat(this.requestFormat);
            }
            catch (MimeException e) {
                log.debug((Object)e.getMessage());
            }
        }
        return this.reqFormat;
    }

    public synchronized MimeType getResponseFormat() {
        if (this.resFormat == null) {
            try {
                this.resFormat = MimeType.createFromFormat(this.responseFormat);
            }
            catch (MimeException e) {
                log.debug((Object)e.getMessage());
            }
        }
        return this.resFormat;
    }

    public Boolean getTransparent() {
        return this.transparent;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public String getPalette() {
        return this.palette;
    }

    private Float getCompressionQuality() {
        if (this.compressionQuality != null && this.compressQual == null) {
            this.compressQual = Float.valueOf(Float.parseFloat(this.compressionQuality));
        }
        return this.compressQual;
    }

    public synchronized ImageWriteParam adjustImageWriteParam(ImageWriteParam param) {
        if (this.imgWriteParam == null) {
            if (this.getCompressionQuality() != null) {
                if (this.getResponseFormat() == ImageMime.jpeg) {
                    param.setCompressionMode(2);
                    param.setCompressionQuality(this.getCompressionQuality().floatValue());
                } else {
                    log.debug((Object)"FormatModifier only supports JPEG image parameters at this time.");
                }
            }
            this.imgWriteParam = param;
        }
        return this.imgWriteParam;
    }
}

