/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.MTSeeder;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.SeedTask;
import org.geowebcache.seed.SeederThreadPoolExecutor;
import org.geowebcache.seed.TruncateTask;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TileRangeIterator;
import org.geowebcache.util.GWCVars;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileBreeder
implements ApplicationContextAware {
    private static final String GWC_SEED_ABORT_LIMIT = "GWC_SEED_ABORT_LIMIT";
    private static final String GWC_SEED_RETRY_WAIT = "GWC_SEED_RETRY_WAIT";
    private static final String GWC_SEED_RETRY_COUNT = "GWC_SEED_RETRY_COUNT";
    private static Log log = LogFactory.getLog(TileBreeder.class);
    private SeederThreadPoolExecutor threadPool;
    private TileLayerDispatcher layerDispatcher;
    private StorageBroker storageBroker;
    private int tileFailureRetryCount = 0;
    private long tileFailureRetryWaitTime = 100L;
    private long totalFailuresBeforeAborting = 1000L;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String retryCount = GWCVars.findEnvVar(applicationContext, GWC_SEED_RETRY_COUNT);
        String retryWait = GWCVars.findEnvVar(applicationContext, GWC_SEED_RETRY_WAIT);
        String abortLimit = GWCVars.findEnvVar(applicationContext, GWC_SEED_ABORT_LIMIT);
        this.tileFailureRetryCount = (int)this.toLong(GWC_SEED_RETRY_COUNT, retryCount, 0L);
        this.tileFailureRetryWaitTime = this.toLong(GWC_SEED_RETRY_WAIT, retryWait, 100L);
        this.totalFailuresBeforeAborting = this.toLong(GWC_SEED_ABORT_LIMIT, abortLimit, 1000L);
        this.checkPositive(this.tileFailureRetryCount, GWC_SEED_RETRY_COUNT);
        this.checkPositive(this.tileFailureRetryWaitTime, GWC_SEED_RETRY_WAIT);
        this.checkPositive(this.totalFailuresBeforeAborting, GWC_SEED_ABORT_LIMIT);
    }

    private void checkPositive(long value, String variable) {
        if (value < 0L) {
            throw new BeanInitializationException("Invalid configuration value for environment variable " + variable + ". It should be a positive integer."){};
        }
    }

    private long toLong(String varName, String paramVal, long defaultVal) {
        if (paramVal == null) {
            return defaultVal;
        }
        try {
            return Long.valueOf(paramVal);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid environment parameter for " + varName + ": '" + paramVal + "'. Using default value: " + defaultVal));
            return defaultVal;
        }
    }

    public void seed(String layerName, SeedRequest sr) throws GeoWebCacheException {
        TileLayer tl = this.findTileLayer(layerName);
        TileRange tr = TileBreeder.createTileRange(sr, tl);
        GWCTask[] tasks = this.createTasks(tr, tl, sr.getType(), sr.getThreadCount(), sr.getFilterUpdate());
        this.dispatchTasks(tasks);
    }

    public GWCTask[] createTasks(TileRange tr, GWCTask.TYPE type, int threadCount, boolean filterUpdate) throws GeoWebCacheException {
        String layerName = tr.layerName;
        TileLayer tileLayer = this.layerDispatcher.getTileLayer(layerName);
        return this.createTasks(tr, tileLayer, type, threadCount, filterUpdate);
    }

    public GWCTask[] createTasks(TileRange tr, TileLayer tl, GWCTask.TYPE type, int threadCount, boolean filterUpdate) throws GeoWebCacheException {
        if (type == GWCTask.TYPE.TRUNCATE || threadCount < 1) {
            log.trace((Object)"Forcing thread count to 1");
            threadCount = 1;
        }
        if (threadCount > this.threadPool.getMaximumPoolSize()) {
            throw new GeoWebCacheException("Asked to use " + threadCount + " threads," + " but maximum is " + this.threadPool.getMaximumPoolSize());
        }
        TileRangeIterator trIter = new TileRangeIterator(tr, tl.getMetaTilingFactors());
        GWCTask[] tasks = new GWCTask[threadCount];
        AtomicLong failureCounter = new AtomicLong();
        AtomicInteger sharedThreadCount = new AtomicInteger();
        for (int i = 0; i < threadCount; ++i) {
            if (type == GWCTask.TYPE.TRUNCATE) {
                tasks[i] = this.createTruncateTask(trIter, tl, filterUpdate);
            } else {
                SeedTask task = (SeedTask)this.createSeedTask(type, trIter, tl, filterUpdate);
                task.setFailurePolicy(this.tileFailureRetryCount, this.tileFailureRetryWaitTime, this.totalFailuresBeforeAborting, failureCounter);
                tasks[i] = task;
            }
            tasks[i].setThreadInfo(sharedThreadCount, i);
        }
        return tasks;
    }

    public void dispatchTasks(GWCTask[] tasks) {
        for (int i = 0; i < tasks.length; ++i) {
            this.threadPool.submit(new MTSeeder(tasks[i]));
        }
    }

    public static TileRange createTileRange(SeedRequest req, TileLayer tl) throws GeoWebCacheException {
        GridSubset gridSubset;
        int zoomStart = req.getZoomStart();
        int zoomStop = req.getZoomStop();
        MimeType mimeType = null;
        String format = req.getMimeFormat();
        if (format == null) {
            mimeType = tl.getMimeTypes().get(0);
        } else {
            try {
                mimeType = MimeType.createFromFormat(format);
            }
            catch (MimeException e4) {
                e4.printStackTrace();
            }
        }
        String gridSetId = req.getGridSetId();
        if (gridSetId == null) {
            gridSetId = tl.getGridSubsetForSRS(req.getSRS()).getName();
        }
        if (gridSetId == null) {
            gridSetId = tl.getGridSubsets().entrySet().iterator().next().getKey();
        }
        if ((gridSubset = tl.getGridSubset(gridSetId)) == null) {
            throw new GeoWebCacheException("Unknown grid set " + gridSetId);
        }
        BoundingBox bounds = req.getBounds();
        long[][] coveredGridLevels = bounds == null ? gridSubset.getCoverages() : gridSubset.getCoverageIntersections(bounds);
        int[] metaTilingFactors = tl.getMetaTilingFactors();
        coveredGridLevels = gridSubset.expandToMetaFactors(coveredGridLevels, metaTilingFactors);
        String layerName = tl.getName();
        Map<String, String> parameters = req.getParameters();
        return new TileRange(layerName, gridSetId, zoomStart, zoomStop, coveredGridLevels, mimeType, parameters);
    }

    private GWCTask createSeedTask(GWCTask.TYPE type, TileRangeIterator trIter, TileLayer tl, boolean doFilterUpdate) throws IllegalArgumentException {
        switch (type) {
            case SEED: {
                return new SeedTask(this.storageBroker, trIter, tl, false, doFilterUpdate);
            }
            case RESEED: {
                return new SeedTask(this.storageBroker, trIter, tl, true, doFilterUpdate);
            }
        }
        throw new IllegalArgumentException("Unknown request type " + (Object)((Object)type));
    }

    private GWCTask createTruncateTask(TileRangeIterator trIter, TileLayer tl, boolean doFilterUpdate) {
        return new TruncateTask(this.storageBroker, trIter.getTileRange(), tl, doFilterUpdate);
    }

    public long[][] getStatusList() {
        Iterator<Map.Entry<Long, GWCTask>> iter = this.threadPool.getRunningTasksIterator();
        long[][] ret = new long[this.threadPool.getMaximumPoolSize()][3];
        int idx = 0;
        while (iter.hasNext()) {
            Map.Entry<Long, GWCTask> entry = iter.next();
            GWCTask task = entry.getValue();
            ret[idx][0] = (int)task.getTilesDone();
            ret[idx][1] = (int)task.getTilesTotal();
            ret[idx][2] = task.getTimeRemaining();
            ++idx;
        }
        return ret;
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.layerDispatcher = tileLayerDispatcher;
    }

    public void setThreadPoolExecutor(SeederThreadPoolExecutor stpe) {
        this.threadPool = stpe;
    }

    public void setStorageBroker(StorageBroker sb) {
        this.storageBroker = sb;
    }

    public TileLayer findTileLayer(String layerName) throws GeoWebCacheException {
        TileLayer layer = null;
        layer = this.layerDispatcher.getTileLayer(layerName);
        if (layer == null) {
            throw new GeoWebCacheException("Uknown layer: " + layerName);
        }
        return layer;
    }

    public Iterator<Map.Entry<Long, GWCTask>> getRunningTasksIterator() {
        return this.threadPool.getRunningTasksIterator();
    }

    public boolean terminateGWCTask(long id) {
        return this.threadPool.terminateGWCTask(id);
    }

    public List<TileLayer> getLayers() {
        return this.layerDispatcher.getLayerList();
    }
}

