/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.io.File;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.StorageException;
import org.geowebcache.util.ApplicationContextProvider;
import org.geowebcache.util.GWCVars;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class DefaultStorageFinder {
    public static final String GWC_CACHE_DIR = "GEOWEBCACHE_CACHE_DIR";
    public static final String GS_DATA_DIR = "GEOSERVER_DATA_DIR";
    public static final String GWC_METASTORE_DISABLED = "GWC_METASTORE_DISABLED";
    public static final String GWC_METASTORE_JDBC_URL = "GWC_METASTORE_JDBC_URL";
    public static final String GWC_METASTORE_USERNAME = "GWC_METASTORE_USERNAME";
    public static final String GWC_METASTORE_PASSWORD = "GWC_METASTORE_PASSWORD";
    public static final String GWC_METASTORE_DRIVER_CLASS = "GWC_METASTORE_DRIVER_CLASS";
    public static final String GWC_BLANK_TILE_PATH = "GWC_BLANK_TILE_PATH";
    private static Log log = LogFactory.getLog(DefaultStorageFinder.class);
    private String defaultPrefix = null;
    private WebApplicationContext context = null;

    public DefaultStorageFinder(ApplicationContextProvider provider) {
        this.context = provider.getApplicationContext();
    }

    public synchronized String getDefaultPath() throws StorageException {
        if (this.defaultPrefix == null) {
            this.determineDefaultPrefix();
            if (this.defaultPrefix == null) {
                throw new StorageException("Unable to find writable path for cache.");
            }
        }
        return this.defaultPrefix;
    }

    public String findEnvVar(String varStr) {
        return GWCVars.findEnvVar((ApplicationContext)this.context, varStr);
    }

    private void determineDefaultPrefix() {
        String logMsg;
        ServletContext serlvCtx = this.context.getServletContext();
        String[] typeStrs = new String[]{"Java environment variable ", "Servlet context parameter ", "System environment variable "};
        String[] varStrs = new String[]{GWC_CACHE_DIR, GS_DATA_DIR, "TEMP", "TMP"};
        String msgPrefix = null;
        int iVar = 0;
        for (int i = 0; i < varStrs.length && this.defaultPrefix == null; ++i) {
            for (int j = 0; j < typeStrs.length && this.defaultPrefix == null; ++j) {
                String value = null;
                String varStr = varStrs[i];
                String typeStr = typeStrs[j];
                switch (j) {
                    case 1: {
                        value = System.getProperty(varStr);
                        break;
                    }
                    case 2: {
                        value = serlvCtx.getInitParameter(varStr);
                        break;
                    }
                    case 3: {
                        value = System.getenv(varStr);
                    }
                }
                if (value == null || value.equalsIgnoreCase("")) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(typeStr + varStr + " is unset"));
                    continue;
                }
                File fh = new File(value);
                msgPrefix = "Found " + typeStr + varStr + " set to " + value;
                if (!fh.exists()) {
                    log.error((Object)(msgPrefix + " , but this path does not exist"));
                    continue;
                }
                if (!fh.isDirectory()) {
                    log.error((Object)(msgPrefix + " , which is not a directory"));
                    continue;
                }
                if (!fh.canWrite()) {
                    log.error((Object)(msgPrefix + " , which is not writeable"));
                    continue;
                }
                this.defaultPrefix = value;
                iVar = i;
            }
        }
        if (this.defaultPrefix == null) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir != null) {
                this.defaultPrefix = tmpDir + File.separator + "geowebcache";
                logMsg = "Reverting to java.io.tmpdir " + this.defaultPrefix + " for storage. " + "Please set " + GWC_CACHE_DIR + ".";
            } else {
                logMsg = "Unable to determine temp directory. Proceeding with undefined results.";
            }
        } else {
            switch (iVar) {
                case 0: {
                    break;
                }
                case 1: {
                    this.defaultPrefix = this.defaultPrefix + File.separator + "gwc";
                    break;
                }
                case 2: 
                case 3: {
                    this.defaultPrefix = this.defaultPrefix + File.separator + "geowebcache";
                }
            }
            logMsg = msgPrefix + ", using it as the default prefix.";
        }
        String warnStr = "*** " + logMsg + " ***";
        StringBuilder stars = new StringBuilder();
        for (int i = 0; i < warnStr.length(); ++i) {
            stars.append("*");
        }
        log.info((Object)stars.toString());
        log.info((Object)warnStr);
        log.info((Object)stars.toString());
    }
}

