/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.io.FileResource;
import org.geowebcache.io.Resource;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.FilePathFilter;
import org.geowebcache.storage.blobstore.file.FilePathGenerator;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class FileBlobStore
implements BlobStore {
    private static Log log = LogFactory.getLog(FileBlobStore.class);
    public static final int BUFFER_SIZE = 32768;
    private final File stagingArea;
    private final String path;
    private final BlobStoreListenerList listeners = new BlobStoreListenerList();
    private static ExecutorService deleteExecutorService;

    public FileBlobStore(DefaultStorageFinder defStoreFinder) throws StorageException {
        this.path = defStoreFinder.getDefaultPath();
        this.stagingArea = new File(this.path, "_gwc_in_progress_deletes_");
        this.createDeleteExecutorService();
        this.issuePendingDeletes();
    }

    public FileBlobStore(String rootPath) throws StorageException {
        this.path = rootPath;
        File fh = new File(this.path);
        if (!(fh.exists() && fh.isDirectory() && fh.canWrite())) {
            throw new StorageException(this.path + " is not writable directory.");
        }
        this.stagingArea = new File(this.path, "_gwc_in_progress_deletes_");
        this.createDeleteExecutorService();
        this.issuePendingDeletes();
    }

    private void issuePendingDeletes() {
        File[] pendings;
        if (!this.stagingArea.exists()) {
            return;
        }
        if (!this.stagingArea.isDirectory() || !this.stagingArea.canWrite()) {
            throw new IllegalStateException("Staging area is not writable or is not a directory: " + this.stagingArea.getAbsolutePath());
        }
        for (File directory : pendings = this.stagingArea.listFiles()) {
            if (!directory.isDirectory()) continue;
            this.deletePending(directory);
        }
    }

    private void deletePending(File pendingDeleteDirectory) {
        deleteExecutorService.submit(new DefferredDirectoryDeleteTask(pendingDeleteDirectory));
    }

    private void createDeleteExecutorService() {
        CustomizableThreadFactory tf = new CustomizableThreadFactory("GWC FileStore delete directory thread-");
        tf.setDaemon(true);
        tf.setThreadPriority(1);
        deleteExecutorService = Executors.newFixedThreadPool(1);
    }

    public void destroy() {
        deleteExecutorService.shutdownNow();
    }

    public boolean delete(String layerName) throws StorageException {
        File layerPath = this.getLayerPath(layerName);
        if (!layerPath.exists() || !layerPath.canWrite()) {
            log.info((Object)(layerPath + " does not exist or is not writable"));
            return false;
        }
        if (!this.stagingArea.exists() && !this.stagingArea.mkdirs()) {
            throw new StorageException("Can't create staging directory for deletes: " + this.stagingArea.getAbsolutePath());
        }
        String dirName = FilePathGenerator.filteredLayerName(layerName);
        File tmpFolder = new File(this.stagingArea, dirName);
        int tries = 0;
        while (tmpFolder.exists()) {
            dirName = FilePathGenerator.filteredLayerName(layerName + "." + ++tries);
            tmpFolder = new File(layerPath.getParentFile(), dirName);
        }
        boolean renamed = layerPath.renameTo(tmpFolder);
        if (!renamed) {
            throw new IllegalStateException("Can't rename " + layerPath.getAbsolutePath() + " to " + tmpFolder.getAbsolutePath() + " for deletion");
        }
        this.deletePending(tmpFolder);
        this.listeners.sendLayerDeleted(layerName);
        return true;
    }

    private File getLayerPath(String layerName) {
        String prefix = this.path + File.separator + FilePathGenerator.filteredLayerName(layerName);
        File layerPath = new File(prefix);
        return layerPath;
    }

    public boolean delete(TileObject stObj) throws StorageException {
        File fh = this.getFileHandleTile(stObj, false);
        if (!fh.exists()) {
            return false;
        }
        long length = fh.length();
        if (!fh.delete()) {
            throw new StorageException("Unable to delete " + fh.getAbsolutePath());
        }
        stObj.setBlobSize((int)length);
        this.listeners.sendTileDeleted(stObj);
        File parentDir = fh.getParentFile();
        if (parentDir.isDirectory() && parentDir.canWrite() && parentDir.list().length == 0) {
            parentDir.delete();
        }
        return true;
    }

    public boolean delete(TileRange trObj) throws StorageException {
        File[] srsZoomDirs;
        int count = 0;
        String prefix = this.path + File.separator + FilePathGenerator.filteredLayerName(trObj.layerName);
        File layerPath = new File(prefix);
        if (!layerPath.exists() || !layerPath.canWrite()) {
            throw new StorageException(prefix + " does not exist or is not writable.");
        }
        FilePathFilter fpf = new FilePathFilter(trObj);
        String layerName = trObj.layerName;
        String gridSetId = trObj.gridSetId;
        String blobFormat = trObj.mimeType.getFormat();
        Map<String, String> parameters = trObj.parameters;
        Long parametersId = null;
        for (File srsZoom : srsZoomDirs = layerPath.listFiles(fpf)) {
            File[] intermediates;
            int zoomLevel = FilePathGenerator.findZoomLevel(srsZoom.getName());
            for (File imd : intermediates = srsZoom.listFiles(fpf)) {
                File[] tiles;
                for (File tile : tiles = imd.listFiles(fpf)) {
                    long length = tile.length();
                    boolean deleted = tile.delete();
                    if (!deleted) continue;
                    String[] coords = tile.getName().split("\\.")[0].split("_");
                    long x = Long.parseLong(coords[0]);
                    long y = Long.parseLong(coords[1]);
                    this.listeners.sendTileDeleted(layerName, gridSetId, blobFormat, parametersId, x, y, zoomLevel, length);
                    ++count;
                }
                String[] chk = imd.list();
                if (chk != null && chk.length != 0) continue;
                imd.delete();
            }
            String[] chk = srsZoom.list();
            if (chk != null && chk.length != 0) continue;
            srsZoom.delete();
            ++count;
        }
        log.debug((Object)("Truncated " + count + " tiles"));
        return true;
    }

    public Resource get(TileObject stObj) throws StorageException {
        File fh = this.getFileHandleTile(stObj, false);
        return this.readFile(fh);
    }

    public void put(TileObject stObj) throws StorageException {
        File fh = this.getFileHandleTile(stObj, true);
        long oldSize = fh.length();
        boolean existed = oldSize > 0L;
        this.writeFile(fh, stObj.getBlob());
        if (existed) {
            this.listeners.sendTileUpdated(stObj, oldSize);
        } else {
            this.listeners.sendTileStored(stObj);
        }
    }

    private File getFileHandleTile(TileObject stObj, boolean create) {
        MimeType mimeType;
        try {
            mimeType = MimeType.createFromFormat(stObj.getBlobFormat());
        }
        catch (MimeException me) {
            log.error((Object)me.getMessage());
            throw new RuntimeException(me);
        }
        String layerName = stObj.getLayerName();
        long[] xyz = stObj.getXYZ();
        String gridSetId = stObj.getGridSetId();
        long parametersId = stObj.getParametersId();
        File tilePath = FilePathGenerator.tilePath(this.path, layerName, xyz, gridSetId, mimeType, parametersId);
        if (create) {
            File parent = tilePath.getParentFile();
            parent.mkdirs();
        }
        return tilePath;
    }

    private Resource readFile(File fh) throws StorageException {
        if (!fh.exists()) {
            return null;
        }
        return new FileResource(fh);
    }

    private void writeFile(File target, Resource source) throws StorageException {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(target);
        }
        catch (FileNotFoundException ioe) {
            throw new StorageException(ioe.getMessage() + " for " + target.getAbsolutePath());
        }
        FileChannel channel = fos.getChannel();
        try {
            source.transferTo(channel);
        }
        catch (IOException ioe) {
            throw new StorageException(ioe.getMessage() + " for " + target.getAbsolutePath());
        }
        finally {
            try {
                channel.close();
            }
            catch (IOException ioe) {
                throw new StorageException(ioe.getMessage() + " for " + target.getAbsolutePath());
            }
        }
    }

    public void clear() throws StorageException {
        throw new StorageException("Not implemented yet!");
    }

    public void addListener(BlobStoreListener listener) {
        this.listeners.addListener(listener);
    }

    public boolean removeListener(BlobStoreListener listener) {
        return this.listeners.removeListener(listener);
    }

    private static class DefferredDirectoryDeleteTask
    implements Runnable {
        private final File directory;

        public DefferredDirectoryDeleteTask(File directory) {
            this.directory = directory;
        }

        public void run() {
            try {
                this.deleteDirectory(this.directory);
            }
            catch (IOException e) {
                log.warn((Object)("Exception occurred while deleting '" + this.directory.getAbsolutePath() + "'"), (Throwable)e);
            }
            catch (InterruptedException e) {
                log.info((Object)("FileStore delete background service interrupted while deleting '" + this.directory.getAbsolutePath() + "'. Process will be resumed at next start up"));
            }
        }

        private void deleteDirectory(File directory) throws IOException, InterruptedException {
            if (!directory.exists()) {
                return;
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                File file = files[i];
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                throw new IOException("Unable to delete " + file.getAbsolutePath());
            }
            if (!directory.delete()) {
                String message = "Unable to delete directory " + directory + ".";
                throw new IOException(message);
            }
        }
    }
}

