/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.metastore.jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.DiscontinuousTileRange;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.StorageObject;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.metastore.jdbc.JDBCUtils;
import org.h2.jdbcx.JdbcConnectionPool;

class JDBCMBWrapper {
    private static Log log = LogFactory.getLog(JDBCMBWrapper.class);
    static int DB_VERSION = 120;
    final String jdbcString;
    final String username;
    final String password;
    final String driverClass;
    private Connection persistentConnection;
    boolean closing = false;
    protected long lockTimeout = 60000L;
    private boolean useConnectionPooling;
    private int maxConnections;
    private JdbcConnectionPool connPool;

    protected JDBCMBWrapper(String driverClass, String jdbcString, String username, String password, boolean useConnectionPooling, int maxConnections) throws StorageException, SQLException {
        this.jdbcString = jdbcString;
        this.username = username;
        this.password = password;
        this.driverClass = driverClass;
        this.useConnectionPooling = useConnectionPooling;
        this.maxConnections = maxConnections;
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new StorageException("Class not found: " + cnfe.getMessage());
        }
        if (!useConnectionPooling) {
            this.persistentConnection = this.getConnection();
        }
        this.checkTables();
    }

    public JDBCMBWrapper(DefaultStorageFinder defStoreFind, boolean useConnectionPooling, int maxConnections) throws StorageException, SQLException {
        String envStrUsername = defStoreFind.findEnvVar("GWC_METASTORE_USERNAME");
        String envStrPassword = defStoreFind.findEnvVar("GWC_METASTORE_PASSWORD");
        String envStrJdbcUrl = defStoreFind.findEnvVar("GWC_METASTORE_JDBC_URL");
        String envStrDriver = defStoreFind.findEnvVar("GWC_METASTORE_DRIVER_CLASS");
        this.useConnectionPooling = useConnectionPooling;
        this.maxConnections = maxConnections;
        this.username = envStrUsername != null ? envStrUsername : "sa";
        this.password = envStrPassword != null ? envStrPassword : "";
        this.driverClass = envStrDriver != null ? envStrDriver : "org.h2.Driver";
        if (envStrJdbcUrl != null) {
            this.jdbcString = envStrJdbcUrl;
        } else {
            String path = defStoreFind.getDefaultPath() + File.separator + "meta_jdbc_h2";
            File dir = new File(path);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new StorageException("Unable to create " + dir.getAbsolutePath() + " for H2 database.");
            }
            this.jdbcString = "jdbc:h2:file:" + path + File.separator + "gwc_metastore" + ";TRACE_LEVEL_FILE=0;AUTO_SERVER=TRUE";
        }
        try {
            Class.forName(this.driverClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new StorageException("Class not found: " + cnfe.getMessage());
        }
        if (!useConnectionPooling) {
            this.persistentConnection = this.getConnection();
        }
        this.checkTables();
    }

    protected Connection getConnection() throws SQLException {
        Connection conn;
        if (this.closing) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is being shut down");
        }
        if (this.useConnectionPooling) {
            if (this.connPool == null) {
                this.connPool = JdbcConnectionPool.create((String)this.jdbcString, (String)this.username, (String)(this.password == null ? "" : this.password));
                this.connPool.setMaxConnections(this.maxConnections);
            }
            conn = this.connPool.getConnection();
        } else {
            conn = DriverManager.getConnection(this.jdbcString, this.username, this.password);
        }
        conn.setAutoCommit(true);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTables() throws StorageException, SQLException {
        Connection conn = this.getConnection();
        try {
            this.condCreate(conn, "LAYERS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(254) UNIQUE", "VALUE", null);
            this.condCreate(conn, "PARAMETERS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(254) UNIQUE", "VALUE", null);
            this.condCreate(conn, "FORMATS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(126) UNIQUE", "VALUE", null);
            this.condCreate(conn, "GRIDSETS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(126) UNIQUE", "VALUE", null);
            int fromVersion = this.getDbVersion(conn);
            log.info((Object)("MetaStore database is version " + fromVersion));
            if (fromVersion != DB_VERSION) {
                if (fromVersion < DB_VERSION) {
                    this.runDbUpgrade(conn, fromVersion);
                } else {
                    log.error((Object)"Metastore database is newer than the runnin version of GWC. Proceeding with undefined results.");
                }
            }
            this.checkWFSTable(conn);
            this.checkTilesTable(conn);
        }
        finally {
            JDBCUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getDbVersion(Connection conn) throws SQLException, StorageException {
        ResultSet rs;
        Statement st;
        block3: {
            int n;
            this.condCreate(conn, "VARIABLES", "KEY VARCHAR(32), VALUE VARCHAR(128)", "KEY", null);
            st = null;
            rs = null;
            try {
                int cur_db_version;
                st = conn.createStatement();
                rs = st.executeQuery("SELECT VALUE FROM VARIABLES WHERE KEY LIKE 'db_version'");
                if (!rs.first()) break block3;
                String db_versionStr = rs.getString("value");
                n = cur_db_version = Integer.parseInt(db_versionStr);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close(st);
                throw throwable;
            }
            JDBCUtils.close(rs);
            JDBCUtils.close(st);
            return n;
        }
        st.execute("INSERT INTO VARIABLES (KEY,VALUE)  VALUES ('db_version'," + DB_VERSION + ")");
        int n = DB_VERSION;
        JDBCUtils.close(rs);
        JDBCUtils.close(st);
        return n;
    }

    private void checkWFSTable(Connection conn) throws SQLException {
        this.condCreate(conn, "WFS", "WFS_ID BIGINT AUTO_INCREMENT PRIMARY KEY, PARAMETERS_ID BIGINT, QUERY_BLOB_MD5 VARCHAR(32), QUERY_BLOB_SIZE INT, BLOB_SIZE INT, CREATED BIGINT, ACCESS_LAST BIGINT, ACCESS_COUNT BIGINT, LOCK TIMESTAMP", "PARAMETERS_ID", "QUERY_BLOB_MD5, QUERY_BLOB_SIZE");
    }

    private void checkTilesTable(Connection conn) throws SQLException {
        this.condCreate(conn, "TILES", "TILE_ID BIGINT AUTO_INCREMENT PRIMARY KEY, LAYER_ID BIGINT, X BIGINT, Y BIGINT, Z BIGINT, GRIDSET_ID INT, FORMAT_ID BIGINT, PARAMETERS_ID BIGINT, BLOB_SIZE INT, CREATED BIGINT, ACCESS_LAST BIGINT, ACCESS_COUNT BIGINT, LOCK TIMESTAMP", "LAYER_ID, X, Y, Z, GRIDSET_ID, FORMAT_ID, PARAMETERS_ID", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void condCreate(Connection conn, String tableName, String columns, String indexColumns, String index2Columns) throws SQLException {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute("CREATE TABLE IF NOT EXISTS " + tableName + " (" + columns + ")");
            st.execute("CREATE INDEX IF NOT EXISTS IDX_" + tableName + " ON " + tableName + " (" + indexColumns + ")");
            if (index2Columns != null) {
                st.execute("CREATE INDEX IF NOT EXISTS IDX2_" + tableName + " ON " + tableName + " (" + index2Columns + ")");
            }
        }
        finally {
            JDBCUtils.close(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDbUpgrade(Connection conn, int fromVersion) {
        Statement st;
        PreparedStatement prep;
        String query;
        log.info((Object)("Upgrading  H2 database from " + fromVersion + " to " + DB_VERSION));
        boolean earlier = false;
        if (fromVersion == 110) {
            log.info((Object)"Running database upgrade from 110 to 111");
            earlier = true;
            try {
                query = "UPDATE VARIABLES SET VALUE = ? WHERE KEY = ?";
                prep = conn.prepareStatement(query);
                try {
                    prep.setString(1, "111");
                    prep.setString(2, "db_version");
                    prep.execute();
                }
                finally {
                    JDBCUtils.close(prep);
                }
                query = "ALTER TABLE TILES ADD LOCK TIMESTAMP";
                st = conn.createStatement();
                try {
                    st.execute(query);
                }
                finally {
                    JDBCUtils.close(st);
                }
                query = "ALTER TABLE WFS ADD LOCK TIMESTAMP";
                st = conn.createStatement();
                try {
                    st.execute(query);
                }
                finally {
                    JDBCUtils.close(st);
                }
                log.info((Object)"Database upgrade from 110 to 111 completed");
            }
            catch (SQLException se) {
                log.error((Object)("110 to 111 upgrade failed: " + se.getMessage()));
            }
        }
        if (fromVersion == 111 || earlier) {
            log.info((Object)"Running database upgrade from 111 to 120");
            try {
                query = "UPDATE VARIABLES SET VALUE = ? WHERE KEY = ?";
                prep = conn.prepareStatement(query);
                try {
                    prep.setString(1, "120");
                    prep.setString(2, "db_version");
                    prep.execute();
                }
                finally {
                    JDBCUtils.close(prep);
                }
                query = "ALTER TABLE TILES ALTER COLUMN SRS_ID RENAME TO GRIDSET_ID";
                st = conn.createStatement();
                try {
                    st.execute(query);
                }
                finally {
                    JDBCUtils.close(st);
                }
                query = "SELECT GRIDSET_ID FROM TILES GROUP BY GRIDSET_ID";
                st = conn.createStatement();
                try {
                    ResultSet rs = st.executeQuery(query);
                    try {
                        while (rs.next()) {
                            int val = rs.getInt(1);
                            query = "INSERT INTO GRIDSETS (ID, VALUE) VALUES (?,?)";
                            prep = conn.prepareStatement(query);
                            try {
                                prep.setLong(1, val);
                                prep.setString(2, "EPSG:" + val);
                                prep.executeUpdate();
                            }
                            finally {
                                JDBCUtils.close(prep);
                            }
                        }
                    }
                    finally {
                        JDBCUtils.close(rs);
                    }
                }
                finally {
                    JDBCUtils.close(st);
                }
                log.info((Object)"Database upgrade from 111 to 120 completed");
            }
            catch (SQLException se) {
                log.error((Object)("111 to 120 upgrade failed: " + se.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTile(TileObject stObj) throws SQLException {
        Connection conn = this.getConnection();
        try {
            this.deleteTile(conn, stObj);
        }
        finally {
            JDBCUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteTile(Connection conn, TileObject stObj) throws SQLException {
        String query = stObj.getParametersId() == -1L ? "DELETE FROM TILES WHERE  LAYER_ID = ? AND X = ? AND Y = ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL" : "DELETE FROM TILES WHERE  LAYER_ID = ? AND X = ? AND Y = ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ?";
        long[] xyz = stObj.getXYZ();
        PreparedStatement prep = conn.prepareStatement(query);
        try {
            prep.setLong(1, stObj.getLayerId());
            prep.setLong(2, xyz[0]);
            prep.setLong(3, xyz[1]);
            prep.setLong(4, xyz[2]);
            prep.setLong(5, stObj.getGridSetIdId());
            prep.setLong(6, stObj.getFormatId());
            if (stObj.getParametersId() != -1L) {
                prep.setLong(7, stObj.getParametersId());
            }
            prep.execute();
        }
        finally {
            JDBCUtils.close(prep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getTile(TileObject stObj) throws SQLException {
        String query = stObj.getParametersId() == -1L ? "SELECT TILE_ID,BLOB_SIZE,CREATED,LOCK,NOW() FROM TILES WHERE  LAYER_ID = ? AND X = ? AND Y = ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL LIMIT 1 " : "SELECT TILE_ID,BLOB_SIZE,CREATED,LOCK,NOW() FROM TILES WHERE  LAYER_ID = ? AND X = ? AND Y = ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ? LIMIT 1 ";
        long[] xyz = stObj.getXYZ();
        Connection conn = this.getConnection();
        PreparedStatement prep = null;
        try {
            ResultSet rs;
            block13: {
                block14: {
                    boolean bl;
                    prep = conn.prepareStatement(query);
                    prep.setLong(1, stObj.getLayerId());
                    prep.setLong(2, xyz[0]);
                    prep.setLong(3, xyz[1]);
                    prep.setLong(4, xyz[2]);
                    prep.setLong(5, stObj.getGridSetIdId());
                    prep.setLong(6, stObj.getFormatId());
                    if (stObj.getParametersId() != -1L) {
                        prep.setLong(7, stObj.getParametersId());
                    }
                    rs = prep.executeQuery();
                    try {
                        if (!rs.first()) break block13;
                        Timestamp lock = rs.getTimestamp(4);
                        if (lock == null) break block14;
                        Timestamp now = rs.getTimestamp(5);
                        long diff = now.getTime() - lock.getTime();
                        if (diff > this.lockTimeout) {
                            log.warn((Object)("Database lock exceeded (" + diff + "ms , " + lock.toString() + ") for " + stObj.toString() + ", clearing tile."));
                            this.deleteTile(conn, stObj);
                            stObj.setStatus(StorageObject.Status.EXPIRED_LOCK);
                        } else {
                            stObj.setStatus(StorageObject.Status.LOCK);
                        }
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        JDBCUtils.close(rs);
                        throw throwable;
                    }
                    JDBCUtils.close(rs);
                    return bl;
                }
                stObj.setId(rs.getLong(1));
                stObj.setBlobSize(rs.getInt(2));
                stObj.setCreated(rs.getLong(3));
                stObj.setStatus(StorageObject.Status.HIT);
                boolean bl = true;
                JDBCUtils.close(rs);
                return bl;
            }
            stObj.setStatus(StorageObject.Status.MISS);
            boolean bl = false;
            JDBCUtils.close(rs);
            return bl;
        }
        finally {
            JDBCUtils.close(prep);
            JDBCUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTile(TileObject stObj) throws SQLException, StorageException {
        String query = "MERGE INTO TILES(LAYER_ID,X,Y,Z,GRIDSET_ID,FORMAT_ID,PARAMETERS_ID,BLOB_SIZE,LOCK,CREATED) KEY(LAYER_ID,X,Y,Z,GRIDSET_ID,FORMAT_ID,PARAMETERS_ID) VALUES(?,?,?,?,?,?,?,?,NOW(),?)";
        long[] xyz = stObj.getXYZ();
        Connection conn = this.getConnection();
        try {
            Long insertId;
            PreparedStatement prep = conn.prepareStatement(query, 1);
            try {
                prep.setLong(1, stObj.getLayerId());
                prep.setLong(2, xyz[0]);
                prep.setLong(3, xyz[1]);
                prep.setLong(4, xyz[2]);
                prep.setLong(5, stObj.getGridSetIdId());
                prep.setLong(6, stObj.getFormatId());
                if (stObj.getParametersId() == -1L) {
                    prep.setNull(7, -5);
                } else {
                    prep.setLong(7, stObj.getParametersId());
                }
                prep.setInt(8, stObj.getBlobSize());
                prep.setLong(9, System.currentTimeMillis());
                insertId = this.wrappedInsert(prep);
            }
            finally {
                JDBCUtils.close(prep);
            }
            if (insertId == null) {
                log.error((Object)("Did not receive a id for " + query));
            } else {
                stObj.setId(insertId);
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockTile(TileObject stObj) throws SQLException, StorageException {
        String query = null;
        query = stObj.getParametersId() == -1L ? "UPDATE TILES SET LOCK = NULL WHERE   LAYER_ID = ? AND X = ? AND Y = ? AND Z = ?  AND GRIDSET_ID = ? AND FORMAT_ID = ? AND  PARAMETERS_ID IS NULL" : "UPDATE TILES SET LOCK = NULL WHERE   LAYER_ID = ? AND X = ? AND Y = ? AND Z = ?  AND GRIDSET_ID = ? AND FORMAT_ID = ? AND  PARAMETERS_ID = ?";
        long[] xyz = stObj.getXYZ();
        Connection conn = this.getConnection();
        PreparedStatement prep = null;
        try {
            int affected;
            prep = conn.prepareStatement(query);
            prep.setLong(1, stObj.getLayerId());
            prep.setLong(2, xyz[0]);
            prep.setLong(3, xyz[1]);
            prep.setLong(4, xyz[2]);
            prep.setLong(5, stObj.getGridSetIdId());
            prep.setLong(6, stObj.getFormatId());
            if (stObj.getParametersId() != -1L) {
                prep.setLong(7, stObj.getParametersId());
            }
            if ((affected = prep.executeUpdate()) == 1) {
                boolean bl = true;
                return bl;
            }
            log.error((Object)("Expected to clear lock on one row, but got " + affected));
            boolean bl = false;
            return bl;
        }
        finally {
            JDBCUtils.close(prep);
            JDBCUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long wrappedInsert(PreparedStatement st) throws SQLException {
        ResultSet rs;
        block3: {
            Long l;
            rs = null;
            try {
                st.executeUpdate();
                rs = st.getGeneratedKeys();
                if (!rs.next()) break block3;
                l = rs.getLong(1);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                throw throwable;
            }
            JDBCUtils.close(rs);
            return l;
        }
        Long l = null;
        JDBCUtils.close(rs);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.closing = true;
            try {
                conn.createStatement().execute("SHUTDOWN");
            }
            catch (SQLException se) {
                log.warn((Object)("SHUTDOWN call to JDBC resulted in: " + se.getMessage()));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Couldn't obtain JDBC Connection to perform database shut down", (Throwable)e);
        }
        finally {
            if (conn != null) {
                boolean closed = false;
                try {
                    closed = conn.isClosed();
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
                if (!closed) {
                    JDBCUtils.close(conn);
                }
            }
        }
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.gc();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.gc();
    }

    private PreparedStatement getTileSet(Connection conn, long layerId, long formatId, long parametersId, long zoomLevel, long[] bounds, long srsNumber) throws SQLException {
        String query = parametersId == -1L ? "SELECT TILE_ID, X, Y, Z FROM TILES WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL" : "SELECT TILE_ID, X, Y, Z FROM TILES WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ?";
        PreparedStatement prep = conn.prepareStatement(query);
        prep.setLong(1, layerId);
        prep.setLong(2, bounds[0]);
        prep.setLong(3, bounds[2]);
        prep.setLong(4, bounds[1]);
        prep.setLong(5, bounds[3]);
        prep.setLong(6, zoomLevel);
        prep.setLong(7, srsNumber);
        prep.setLong(8, formatId);
        if (parametersId != -1L) {
            prep.setLong(9, parametersId);
        }
        return prep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRange(Connection conn, long layerId, long formatId, long parametersId, int zoomLevel, long[] bounds, long gridSetIdId) throws SQLException {
        String query = parametersId == -1L ? "DELETE FROM TILES WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL" : "DELETE FROM TILES WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ?";
        PreparedStatement prep = conn.prepareStatement(query);
        try {
            prep.setLong(1, layerId);
            prep.setLong(2, bounds[0]);
            prep.setLong(3, bounds[2]);
            prep.setLong(4, bounds[1]);
            prep.setLong(5, bounds[3]);
            prep.setLong(6, zoomLevel);
            prep.setLong(7, gridSetIdId);
            prep.setLong(8, formatId);
            if (parametersId != -1L) {
                prep.setLong(9, parametersId);
            }
            prep.execute();
        }
        finally {
            JDBCUtils.close(prep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLayer(long layerId) throws SQLException {
        String query = "DELETE FROM TILES WHERE LAYER_ID = ?";
        Connection conn = this.getConnection();
        try {
            PreparedStatement prep = conn.prepareStatement(query);
            try {
                prep.setLong(1, layerId);
                prep.execute();
            }
            finally {
                JDBCUtils.close(prep);
            }
        }
        finally {
            JDBCUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRange(BlobStore blobStore, TileRange trObj, int zoomLevel, long layerId, long formatId, long parametersId, long gridSetIdId) {
        ResultSet rs;
        PreparedStatement tileSetQuery;
        Connection conn;
        block12: {
            DiscontinuousTileRange dtrObj = null;
            long[] deletedTiles = null;
            if (trObj instanceof DiscontinuousTileRange) {
                dtrObj = (DiscontinuousTileRange)trObj;
                deletedTiles = new long[100];
            }
            long[] bounds = trObj.rangeBounds[zoomLevel];
            try {
                conn = this.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            tileSetQuery = null;
            rs = null;
            try {
                tileSetQuery = this.getTileSet(conn, layerId, formatId, parametersId, zoomLevel, bounds, gridSetIdId);
                rs = tileSetQuery.executeQuery();
                int deletedIdx = 0;
                while (rs.next()) {
                    long[] xyz = new long[]{rs.getLong(2), rs.getLong(3), rs.getLong(4)};
                    if (dtrObj != null && !dtrObj.contains(xyz)) continue;
                    TileObject to = TileObject.createQueryTileObject(trObj.layerName, xyz, trObj.gridSetId, trObj.mimeType.getFormat(), trObj.parameters);
                    to.setParamtersId(parametersId);
                    try {
                        blobStore.delete(to);
                    }
                    catch (StorageException e) {
                        log.debug((Object)("Error while deleting range: " + e.getMessage()));
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (deletedTiles == null) continue;
                    deletedTiles[deletedIdx] = rs.getLong(1);
                    if (++deletedIdx != deletedTiles.length) continue;
                    this.deleteTileSet(conn, deletedTiles, deletedIdx);
                    deletedIdx = 0;
                }
                if (deletedTiles != null) {
                    this.deleteTileSet(conn, deletedTiles, deletedIdx);
                    break block12;
                }
                this.deleteRange(conn, layerId, formatId, parametersId, zoomLevel, bounds, gridSetIdId);
            }
            catch (SQLException e) {
                boolean bl;
                try {
                    log.error((Object)("deleteRange failed: " + e.getMessage()));
                    e.printStackTrace();
                    bl = false;
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close(tileSetQuery);
                    JDBCUtils.close(conn);
                    throw throwable;
                }
                JDBCUtils.close(rs);
                JDBCUtils.close(tileSetQuery);
                JDBCUtils.close(conn);
                return bl;
            }
        }
        JDBCUtils.close(rs);
        JDBCUtils.close(tileSetQuery);
        JDBCUtils.close(conn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTileSet(Connection conn, long[] tileIds, int stopIdx) throws SQLException {
        if (stopIdx == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM TILES WHERE TILE_ID IN (");
        sb.append(tileIds[0]);
        for (int i = 1; i < stopIdx; ++i) {
            sb.append(",");
            sb.append(tileIds[i]);
        }
        sb.append(")");
        PreparedStatement prepDel = conn.prepareStatement(sb.toString());
        try {
            prepDel.execute();
        }
        finally {
            JDBCUtils.close(prepDel);
        }
        log.debug((Object)("Deleted " + Arrays.toString(tileIds)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireRange(TileRange trObj, int zoomLevel, long layerId, long formatId, long parametersId, long gridSetIdId) throws SQLException {
        long[] bounds = trObj.rangeBounds[zoomLevel];
        String query = parametersId == -1L ? "UPDATE TILES SET CREATED = -1 WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL" : "UPDATE TILES SET CREATED = -1 WHERE  LAYER_ID = ? AND X >= ? AND X <= ? AND Y >= ? AND Y <= ? AND Z = ? AND GRIDSET_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ?";
        Connection conn = this.getConnection();
        try {
            PreparedStatement prep = conn.prepareStatement(query);
            try {
                prep.setLong(1, layerId);
                prep.setLong(2, bounds[0]);
                prep.setLong(3, bounds[2]);
                prep.setLong(4, bounds[1]);
                prep.setLong(5, bounds[3]);
                prep.setLong(6, zoomLevel);
                prep.setLong(7, gridSetIdId);
                prep.setLong(8, formatId);
                if (parametersId != -1L) {
                    prep.setLong(9, parametersId);
                }
                prep.execute();
            }
            finally {
                JDBCUtils.close(prep);
            }
        }
        finally {
            JDBCUtils.close(conn);
        }
    }
}

