/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtils {
    private static Log log = LogFactory.getLog(FileUtils.class);

    public static boolean rmFileCacheDir(File path, ExtensionFileLister extfl) {
        if (path.exists()) {
            File[] files = null;
            files = extfl != null ? path.listFiles(extfl) : path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtils.rmFileCacheDir(files[i], extfl);
                    continue;
                }
                if (files[i].delete()) continue;
                log.error((Object)("Unable to delete " + files[i].getAbsolutePath()));
            }
        }
        return path.delete();
    }

    public static void traverseDepth(File path, FileFilter filter) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        if (!(path.exists() && path.isDirectory() && path.canRead())) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " either does not exist, or is not a readable directory");
        }
        String[] fileNames = path.list();
        ArrayList<File> subDirectories = new ArrayList<File>();
        for (int i = 0; i < fileNames.length; ++i) {
            File file = new File(path, fileNames[i]);
            if (file.isDirectory()) {
                subDirectories.add(file);
            }
            filter.accept(file);
        }
        if (subDirectories.size() > 0) {
            for (File subdir : subDirectories) {
                boolean accepted = filter.accept(subdir);
                if (!accepted || !subdir.isDirectory()) continue;
                FileUtils.traverseDepth(subdir, filter);
            }
        }
    }

    public static class ExtensionFileLister
    implements FilenameFilter {
        private String prefix;
        private String extension;

        public ExtensionFileLister(String prefix, String extension) {
            this.prefix = prefix;
            this.extension = extension == null ? null : "." + extension;
        }

        public boolean accept(File directory, String filename) {
            if (this.prefix != null && !filename.startsWith(this.prefix)) {
                return false;
            }
            if (this.extension != null) {
                return filename.endsWith(this.extension);
            }
            return true;
        }
    }
}

