/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.filter;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.rest.RestletException;
import org.geowebcache.util.ServletUtils;
import org.restlet.data.Status;

public class ZipFilterUpdate {
    private static Log log = LogFactory.getLog(ZipFilterUpdate.class);
    InputStream is;

    public ZipFilterUpdate(InputStream is) {
        this.is = is;
    }

    public void runUpdate(RequestFilter filter, TileLayer tl) throws RestletException {
        try {
            ZipInputStream zis = new ZipInputStream(this.is);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                log.info((Object)("Reading " + ze.getName() + " (" + ze.getSize() + " bytes ) for " + filter.getName()));
                if (ze.isDirectory()) {
                    throw new RestletException("Zip file cannot contain directories.", Status.CLIENT_ERROR_BAD_REQUEST);
                }
                String[] parsedName = this.parseName(ze.getName());
                byte[] data = ServletUtils.readStream((InputStream)zis, (int)16384, (int)1500, (boolean)false);
                try {
                    filter.update(data, tl, parsedName[0], Integer.parseInt(parsedName[1]));
                }
                catch (GeoWebCacheException e) {
                    throw new RestletException("Error updating " + filter.getName() + ": " + e.getMessage(), Status.SERVER_ERROR_INTERNAL);
                }
                ze = zis.getNextEntry();
            }
        }
        catch (IOException ioe) {
            throw new RestletException("IOException while reading zip, " + ioe.getMessage(), Status.CLIENT_ERROR_BAD_REQUEST);
        }
        finally {
            try {
                this.is.close();
            }
            catch (IOException e) {}
        }
    }

    String[] parseName(String fileName) throws RestletException {
        String[] strs = fileName.split("_");
        String[] zExt = strs[2].split("\\.");
        strs[2] = zExt[0];
        String[] gridSetIdZ = new String[]{strs[1], strs[2]};
        return gridSetIdZ;
    }
}

