/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.importer;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.DefaultItemReuseStrategy;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.importer.LayerResource;
import org.geoserver.web.data.importer.WMSLayerProvider;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSLayerImporterPage
extends GeoServerSecuredPage {
    String storeId;
    private GeoServerTablePanel<LayerResource> layers;
    private WMSLayerProvider provider;
    int importCount;
    int errorCount;
    int updateCount;
    private Form form;

    public WMSLayerImporterPage(PageParameters params) {
        this.storeId = params.getString("storeId");
        WMSStoreInfo store = (WMSStoreInfo)this.getCatalog().getStore(this.storeId, WMSStoreInfo.class);
        this.provider = new WMSLayerProvider();
        this.provider.setStoreId(this.storeId);
        if (this.provider.size() <= 0) {
            this.error((Serializable)((Object)new ParamResourceModel("storeEmpty", (Component)this, store.getName(), store.getWorkspace().getName()).getString()));
        }
        this.form = new Form("form", (IModel)new CompoundPropertyModel((Object)this));
        this.form.setOutputMarkupId(true);
        this.add(new Component[]{this.form});
        this.layers = new GeoServerTablePanel<LayerResource>("layerChooser", (GeoServerDataProvider)this.provider, true){

            @Override
            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<LayerResource> property) {
                if (property == WMSLayerProvider.NAME) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property == WMSLayerProvider.STATUS) {
                    Fragment f = new Fragment(id, "labelIcon", (MarkupContainer)WMSLayerImporterPage.this);
                    f.add(new Component[]{new Image("icon", (IModel)new IconModel(itemModel))});
                    f.add(new Component[]{new Label("label", (IModel)new StatusModel(itemModel))});
                    return f;
                }
                if (property == WMSLayerProvider.ACTION) {
                    LayerResource resource = (LayerResource)itemModel.getObject();
                    LayerResource.LayerStatus status = resource.getStatus();
                    if (status == LayerResource.LayerStatus.PUBLISHED || status == LayerResource.LayerStatus.NEWLY_PUBLISHED || status == LayerResource.LayerStatus.UPDATED) {
                        return WMSLayerImporterPage.this.resourceChooserLink(id, itemModel, (IModel)new ParamResourceModel("NewLayerPage.publishAgain", (Component)this, new Object[0]));
                    }
                    return WMSLayerImporterPage.this.resourceChooserLink(id, itemModel, (IModel)new ParamResourceModel("NewLayerPage.publish", (Component)this, new Object[0]));
                }
                return null;
            }
        };
        this.layers.setItemReuseStrategy(DefaultItemReuseStrategy.getInstance());
        this.layers.setFilterable(true);
        this.form.add(new Component[]{this.layers});
        AjaxSubmitLink submitLink = this.submitLink();
        this.form.add(new Component[]{submitLink});
        this.form.add(new Component[]{this.importAllLink()});
    }

    SimpleAjaxLink resourceChooserLink(String id, IModel itemModel, IModel label) {
        return new SimpleAjaxLink(id, itemModel, label){

            protected void onClick(AjaxRequestTarget target) {
                LayerResource resource = (LayerResource)this.getDefaultModelObject();
                this.setResponsePage((Page)new ResourceConfigurationPage(WMSLayerImporterPage.this.buildLayerInfo(resource), true));
            }
        };
    }

    LayerInfo buildLayerInfo(LayerResource resource) {
        Catalog catalog = this.getCatalog();
        StoreInfo store = catalog.getStore(this.storeId, StoreInfo.class);
        try {
            CatalogBuilder builder = new CatalogBuilder(catalog);
            builder.setStore(store);
            WMSLayerInfo wli = builder.buildWMSLayer(resource.getLocalName());
            return builder.buildLayer(wli);
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while building the resources for the configuration page", e);
        }
    }

    AjaxSubmitLink submitLink() {
        return new AjaxSubmitLink("import"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    List<LayerResource> selection = WMSLayerImporterPage.this.layers.getSelection();
                    if (selection.size() == 0) {
                        this.error((Serializable)((Object)new ParamResourceModel("selectionEmpty", (Component)WMSLayerImporterPage.this, new Object[0]).getString()));
                    } else {
                        WMSLayerImporterPage.this.publishLayers(selection);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while setting up mass import", e);
                }
                target.addComponent(form);
                target.addComponent((Component)WMSLayerImporterPage.this.feedbackPanel);
            }
        };
    }

    void publishLayers(List<LayerResource> selection) {
        Catalog catalog = this.getCatalog();
        CatalogBuilder builder = new CatalogBuilder(catalog);
        WMSStoreInfo store = (WMSStoreInfo)this.getCatalog().getStore(this.storeId, WMSStoreInfo.class);
        builder.setStore((StoreInfo)store);
        this.importCount = 0;
        this.errorCount = 0;
        this.updateCount = 0;
        for (LayerResource resource : selection) {
            this.publishLayer(resource, builder, store, catalog);
        }
        this.createImportReport();
        this.layers.reset();
        this.provider.updateLayerOrder();
    }

    AjaxSubmitLink importAllLink() {
        return new AjaxSubmitLink("importAll"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    WMSLayerImporterPage.this.publishLayers(WMSLayerImporterPage.this.provider.getItems());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while setting up mass import", e);
                }
                target.addComponent(form);
                target.addComponent((Component)WMSLayerImporterPage.this.feedbackPanel);
            }
        };
    }

    private void publishLayer(LayerResource layer, CatalogBuilder builder, WMSStoreInfo store, Catalog catalog) {
        LayerInfo li;
        WMSLayerInfo wli;
        try {
            wli = builder.buildWMSLayer(layer.getLocalName());
            li = builder.buildLayer(wli);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error building WMS cascading layer " + layer.getLocalName(), e);
            layer.setStatus(LayerResource.LayerStatus.ERROR);
            layer.setError(e.getMessage());
            ++this.errorCount;
            return;
        }
        WMSLayerInfo exists = (WMSLayerInfo)catalog.getResourceByStore((StoreInfo)store, li.getName(), WMSLayerInfo.class);
        if (exists != null) {
            builder.updateWMSLayer(exists, wli);
            layer.setStatus(LayerResource.LayerStatus.UPDATED);
            ++this.updateCount;
        } else {
            try {
                catalog.add((ResourceInfo)wli);
                catalog.add(li);
                layer.setStatus(LayerResource.LayerStatus.NEWLY_PUBLISHED);
                ++this.importCount;
            }
            catch (Exception e) {
                catalog.remove((ResourceInfo)wli);
                LOGGER.log(Level.WARNING, "Error auto configuring WMS cascading layer " + li.getName(), e);
                layer.setStatus(LayerResource.LayerStatus.ERROR);
                layer.setError(e.getMessage());
                ++this.errorCount;
            }
        }
    }

    private void createImportReport() {
        if (this.importCount > 0) {
            this.info("Succesfully imported " + this.importCount + " layers");
        } else {
            this.info("No new layers were imported");
        }
        if (this.updateCount > 0) {
            this.info("Updated " + this.updateCount + " layers");
        }
        if (this.errorCount > 0) {
            this.error((Serializable)((Object)("Unable to import " + this.errorCount + " layers, you may want to import them manually")));
        }
    }

    final class IconModel
    implements IModel {
        IModel layerResource;

        public IconModel(IModel layerResource) {
            this.layerResource = layerResource;
        }

        public Object getObject() {
            LayerResource resource = (LayerResource)this.layerResource.getObject();
            if (resource.getStatus() == LayerResource.LayerStatus.ERROR) {
                return new ResourceReference(GeoServerBasePage.class, "img/icons/silk/error.png");
            }
            if (resource.getStatus() == LayerResource.LayerStatus.NEW) {
                return new ResourceReference(GeoServerBasePage.class, "img/icons/silk/add.png");
            }
            if (resource.getStatus() == LayerResource.LayerStatus.NEWLY_PUBLISHED) {
                return CatalogIconFactory.ENABLED_ICON;
            }
            if (resource.getStatus() == LayerResource.LayerStatus.UPDATED) {
                return new ResourceReference(GeoServerBasePage.class, "img/icons/silk/pencil.png");
            }
            if (resource.getStatus() == LayerResource.LayerStatus.PUBLISHED) {
                return CatalogIconFactory.MAP_ICON;
            }
            return null;
        }

        public void setObject(Object object) {
            throw new UnsupportedOperationException();
        }

        public void detach() {
        }
    }

    final class StatusModel
    implements IModel {
        IModel layerResource;

        public StatusModel(IModel layerResource) {
            this.layerResource = layerResource;
        }

        public Object getObject() {
            LayerResource resource = (LayerResource)this.layerResource.getObject();
            return new ParamResourceModel("WMSLayerImporterPage.status." + (Object)((Object)resource.getStatus()), (Component)WMSLayerImporterPage.this, resource.getError()).getString();
        }

        public void setObject(Object object) {
            throw new UnsupportedOperationException();
        }

        public void detach() {
        }
    }
}

