/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.store.StoreNameValidator;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;

abstract class AbstractWMSStorePage
extends GeoServerSecuredPage {
    protected WorkspacePanel workspacePanel;
    private Form form;
    GeoServerDialog dialog;
    TextParamPanel capabilitiesURL;

    AbstractWMSStorePage() {
    }

    void initUI(WMSStoreInfo store) {
        Model model = new Model((Serializable)store);
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.form = new Form("form", (IModel)model);
        this.add(new Component[]{this.form});
        PropertyModel nameModel = new PropertyModel((Object)model, "name");
        TextParamPanel namePanel = new TextParamPanel("namePanel", (IModel)nameModel, (IModel)new ResourceModel("dataSrcName", "Data Source Name"), true, new IValidator[0]);
        this.form.add(new Component[]{namePanel});
        this.form.add(new Component[]{new TextParamPanel("descriptionPanel", (IModel)new PropertyModel((Object)model, "description"), (IModel)new ResourceModel("description", "Description"), false, new IValidator[0])});
        this.form.add(new Component[]{new CheckBoxParamPanel("enabledPanel", (IModel)new PropertyModel((Object)model, "enabled"), (IModel)new ResourceModel("enabled", "Enabled"))});
        this.workspacePanel = new WorkspacePanel("workspacePanel", (IModel)new PropertyModel((Object)model, "workspace"), (IModel)new ResourceModel("workspace", "Workspace"), true);
        this.form.add(new Component[]{this.workspacePanel});
        this.capabilitiesURL = new TextParamPanel("capabilitiesURL", (IModel)new PropertyModel(this.form.getModelObject(), "capabilitiesURL"), (IModel)new ParamResourceModel("capabilitiesURL", (Component)this, new Object[0]), true, new IValidator[0]);
        this.form.add(new Component[]{this.capabilitiesURL});
        this.form.add(new Component[]{new BookmarkablePageLink("cancel", StorePage.class)});
        this.form.add(new Component[]{this.saveLink()});
        this.form.setDefaultButton((IFormSubmittingComponent)this.saveLink());
        this.form.add(new Component[]{new FeedbackPanel("feedback")});
        StoreNameValidator storeNameValidator = new StoreNameValidator(this.workspacePanel.getFormComponent(), namePanel.getFormComponent(), store.getId());
        this.form.add((IFormValidator)storeNameValidator);
    }

    private AjaxSubmitLink saveLink() {
        return new AjaxSubmitLink("save", this.form){

            protected void onError(AjaxRequestTarget target, Form form) {
                super.onError(target, form);
                target.addComponent((Component)form);
            }

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                WMSStoreInfo info = (WMSStoreInfo)form.getModelObject();
                try {
                    AbstractWMSStorePage.this.onSave(info, target);
                }
                catch (IllegalArgumentException e) {
                    form.error((Serializable)((Object)e.getMessage()));
                    target.addComponent((Component)form);
                }
            }
        };
    }

    protected abstract void onSave(WMSStoreInfo var1, AjaxRequestTarget var2) throws IllegalArgumentException;

    protected void clone(WMSStoreInfo source, WMSStoreInfo target) {
        target.setDescription(source.getDescription());
        target.setEnabled(source.isEnabled());
        target.setName(source.getName());
        target.setType(source.getType());
        target.setCapabilitiesURL(source.getCapabilitiesURL());
        target.setWorkspace(source.getWorkspace());
    }
}

