/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store.raster;

import java.io.FileFilter;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.web.data.store.StoreEditPanel;
import org.geoserver.web.data.store.panel.FileParamPanel;
import org.geoserver.web.wicket.FileExistsValidator;
import org.geoserver.web.wicket.browser.ExtensionFileFilter;
import org.geotools.util.logging.Logging;

public abstract class AbstractRasterFileEditPanel
extends StoreEditPanel {
    private static final Logger LOGGER = Logging.getLogger(AbstractRasterFileEditPanel.class);

    public AbstractRasterFileEditPanel(String componentId, Form storeEditForm, String ... fileExtensions) {
        super(componentId, storeEditForm);
        IModel model = storeEditForm.getModel();
        this.setDefaultModel(model);
        PropertyModel paramsModel = new PropertyModel((Object)model, "connectionParameters");
        FileParamPanel file = new FileParamPanel("url", (IModel)new PropertyModel((Object)model, "URL"), (IModel)new ResourceModel("url", "URL"), true, new IValidator[0]);
        file.getFormComponent().add((IValidator)new FileExistsValidator());
        if (fileExtensions != null && fileExtensions.length > 0) {
            file.setFileFilter((IModel<? extends FileFilter>)new Model((Serializable)new ExtensionFileFilter(fileExtensions)));
        }
        this.add(new Component[]{file});
    }
}

