/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.model.IModel;

public abstract class LiveCollectionModel
implements IModel {
    IModel wrapped;

    public LiveCollectionModel(IModel wrapped) {
        if (wrapped == null) {
            throw new NullPointerException("Live list model cannot wrap a null model");
        }
        this.wrapped = wrapped;
    }

    public void setObject(Object object) {
        Collection collection = (Collection)this.wrapped.getObject();
        collection.clear();
        collection.addAll((Collection)object);
    }

    public void detach() {
        this.wrapped.detach();
    }

    public static LiveCollectionModel list(IModel wrapped) {
        return new LiveCollectionModel(wrapped){

            public Object getObject() {
                return new ArrayList((List)this.wrapped.getObject());
            }
        };
    }

    public static LiveCollectionModel set(IModel wrapped) {
        return new LiveCollectionModel(wrapped){

            public Object getObject() {
                return new HashSet((Set)this.wrapped.getObject());
            }
        };
    }
}

