/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileProvider
extends SortableDataProvider {
    public static final String NAME = "name";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String SIZE = "size";
    private static final Comparator<File> FILE_NAME_COMPARATOR = new AbstractFileComparator(){

        public int compareProperty(File o1, File o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    private static final Comparator<File> FILE_LM_COMPARATOR = new AbstractFileComparator(){

        public int compareProperty(File o1, File o2) {
            long lm2;
            long lm1 = o1.lastModified();
            if (lm1 == (lm2 = o2.lastModified())) {
                return 0;
            }
            return lm1 < lm2 ? -1 : 1;
        }
    };
    private static final Comparator<File> FILE_SIZE_COMPARATOR = new AbstractFileComparator(){

        public int compareProperty(File o1, File o2) {
            long l2;
            long l1 = o1.length();
            if (l1 == (l2 = o2.length())) {
                return 0;
            }
            return l1 < l2 ? -1 : 1;
        }
    };
    IModel directory;
    IModel fileFilter;

    public FileProvider(File directory) {
        this.directory = new Model((Serializable)directory);
    }

    public FileProvider(IModel directory) {
        this.directory = directory;
    }

    public Iterator iterator(int first, int count) {
        int last;
        List<File> files = this.getFilteredFiles();
        Comparator<File> comparator = this.getComparator(this.getSort());
        if (comparator != null) {
            Collections.sort(files, comparator);
        }
        if ((last = first + count) > files.size()) {
            last = files.size();
        }
        return files.subList(first, last).iterator();
    }

    List<File> getFilteredFiles() {
        File[] files;
        File d = (File)this.directory.getObject();
        if (d.isFile()) {
            d = d.getParentFile();
        }
        if ((files = this.fileFilter != null ? d.listFiles(new HiddenFileFilter((FileFilter)this.fileFilter.getObject())) : d.listFiles(new HiddenFileFilter())) != null) {
            return Arrays.asList(files);
        }
        return Collections.emptyList();
    }

    public IModel model(Object object) {
        return new Model((Serializable)((File)object));
    }

    public int size() {
        return this.getFilteredFiles().size();
    }

    private Comparator<File> getComparator(SortParam sort) {
        if (sort == null) {
            return FILE_NAME_COMPARATOR;
        }
        Comparator<File> comparator = null;
        if (NAME.equals(sort.getProperty())) {
            comparator = FILE_NAME_COMPARATOR;
        } else if (LAST_MODIFIED.equals(sort.getProperty())) {
            comparator = FILE_LM_COMPARATOR;
        } else if (SIZE.equals(sort.getProperty())) {
            comparator = FILE_SIZE_COMPARATOR;
        } else {
            throw new IllegalArgumentException("Uknown sorting property " + sort.getProperty());
        }
        if (sort.isAscending()) {
            return comparator;
        }
        return new ReverseComparator(comparator);
    }

    public IModel getDirectory() {
        return this.directory;
    }

    public void setDirectory(IModel directory) {
        this.directory = directory;
    }

    public IModel getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(IModel fileFilter) {
        this.fileFilter = fileFilter;
    }

    private static class HiddenFileFilter
    implements FileFilter {
        FileFilter delegate;

        public HiddenFileFilter() {
        }

        public HiddenFileFilter(FileFilter delegate) {
            this.delegate = delegate;
        }

        public boolean accept(File pathname) {
            if (pathname.isHidden()) {
                return false;
            }
            if (this.delegate != null) {
                return this.delegate.accept(pathname);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseComparator
    implements Comparator<File> {
        Comparator<File> comparator;

        public ReverseComparator(Comparator<File> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(File o1, File o2) {
            return this.comparator.compare(o2, o1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractFileComparator
    implements Comparator<File> {
        private AbstractFileComparator() {
        }

        @Override
        public final int compare(File o1, File o2) {
            if (o1.isDirectory() && !o2.isDirectory()) {
                return -1;
            }
            if (o2.isDirectory() && !o1.isDirectory()) {
                return 1;
            }
            return this.compareProperty(o1, o2);
        }

        protected abstract int compareProperty(File var1, File var2);
    }
}

