/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Rectangle;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.factory.Hints;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.SortByImpl;
import org.geotools.gce.imagemosaic.ImageMosaicDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public final class ImageMosaicReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader,
GridCoverageWriter {
    private static final Logger LOGGER = Logging.getLogger(ImageMosaicReader.class);
    URL sourceURL;
    boolean expandMe;
    PathType pathType;
    ExecutorService multiThreadedLoader = null;
    String locationAttributeName = "location";
    RasterManager rasterManager;
    int maxAllowedTiles = (Integer)ImageMosaicFormat.MAX_ALLOWED_TILES.getDefaultValue();
    ImageReaderSpi suggestedSPI;
    GranuleCatalog catalog;
    String timeAttribute;
    boolean cachingIndex;
    String elevationAttribute;
    String runtimeAttribute;
    boolean imposedBBox;
    boolean heterogeneousGranules;
    static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");

    public ImageMosaicReader(Object source, Hints uHints) throws IOException {
        super(source, uHints);
        Object executor;
        if (this.hints.containsKey((Object)Hints.EXECUTOR_SERVICE) && (executor = uHints.get((Object)Hints.EXECUTOR_SERVICE)) != null && executor instanceof ExecutorService) {
            this.multiThreadedLoader = (ExecutorService)executor;
            if (LOGGER.isLoggable(Level.FINE) && this.multiThreadedLoader instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.multiThreadedLoader;
                LOGGER.fine("Using ThreadPoolExecutor with the following settings: core pool size = " + tpe.getCorePoolSize() + "\nmax pool size = " + tpe.getMaximumPoolSize() + "\nkeep alive time " + tpe.getKeepAliveTime(TimeUnit.MILLISECONDS));
            }
        }
        if (this.hints.containsKey((Object)Hints.MAX_ALLOWED_TILES)) {
            this.maxAllowedTiles = (Integer)this.hints.get((Object)Hints.MAX_ALLOWED_TILES);
        }
        if (source instanceof ImageMosaicDescriptor) {
            this.initReaderFromDescriptor((ImageMosaicDescriptor)source, uHints);
        } else {
            this.initReaderFromURL(source, uHints);
        }
    }

    private void initReaderFromDescriptor(ImageMosaicDescriptor source, Hints uHints) throws DataSourceException {
        Utilities.ensureNonNull((String)"source", (Object)source);
        MosaicConfigurationBean configuration = source.getConfiguration();
        if (configuration == null) {
            throw new DataSourceException("Unable to create reader for this mosaic since we could not parse the configuration.");
        }
        this.extractProperties(configuration);
        this.catalog = source.getCatalog();
        if (this.catalog == null) {
            throw new DataSourceException("Unable to create reader for this mosaic since the inner catalog is null.");
        }
        this.setGridGeometry();
        this.rasterManager = new RasterManager(this);
        this.rasterManager.defaultSM = configuration.getSampleModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReaderFromURL(Object source, Hints hints) throws MalformedURLException, DataSourceException {
        this.sourceURL = Utils.checkSource(source, hints);
        if (this.sourceURL == null) {
            throw new DataSourceException("This plugin accepts File, URL or String. The string may describe a File or an URL");
        }
        MosaicConfigurationBean configuration = this.loadMosaicProperties();
        if (configuration == null) {
            throw new DataSourceException("Unable to create reader for this mosaic since we could not parse the configuration.");
        }
        if (this.hints.containsKey((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE)) {
            this.locationAttributeName = (String)this.hints.get((Object)Hints.MOSAIC_LOCATION_ATTRIBUTE);
        }
        try {
            SimpleFeatureType type;
            this.catalog = GranuleCatalogFactory.createGranuleCatalog(this.sourceURL, configuration);
            if (this.catalog == null) {
                throw new DataSourceException("Unable to create index for this URL " + this.sourceURL);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Connected mosaic reader to its index " + this.sourceURL.toString());
            }
            if ((type = this.catalog.getType()) == null) {
                throw new IllegalArgumentException("Problems when opening the index, no typenames for the schema are defined");
            }
            this.setGridGeometry(configuration.getEnvelope());
            Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
            if (tempCRS != null) {
                this.crs = (CoordinateReferenceSystem)tempCRS;
                LOGGER.log(Level.WARNING, "Using forced coordinate reference system ");
            } else {
                CoordinateReferenceSystem tempcrs = type.getGeometryDescriptor().getCoordinateReferenceSystem();
                if (tempcrs == null) {
                    this.crs = AbstractGridFormat.getDefaultCRS();
                    LOGGER.log(Level.WARNING, "Unable to find a CRS for this coverage, using a default one");
                } else {
                    this.crs = tempcrs;
                }
            }
            if (this.locationAttributeName == null) {
                for (AttributeDescriptor attribute : type.getAttributeDescriptors()) {
                    if (!attribute.getType().getBinding().equals(String.class)) continue;
                    this.locationAttributeName = attribute.getName().toString();
                }
            }
            if (type.getDescriptor(this.locationAttributeName) == null) {
                throw new DataSourceException("The provided name for the location attribute is invalid.");
            }
            if (this.timeAttribute == null) {
                for (AttributeDescriptor attribute : type.getAttributeDescriptors()) {
                    if (attribute.getType().getBinding().equals(java.util.Date.class)) {
                        this.timeAttribute = attribute.getName().toString();
                        break;
                    }
                    if (attribute.getType().getBinding().equals(Timestamp.class)) {
                        this.timeAttribute = attribute.getName().toString();
                        break;
                    }
                    if (!attribute.getType().getBinding().equals(Date.class)) continue;
                    this.timeAttribute = attribute.getName().toString();
                    break;
                }
            }
            if (this.timeAttribute != null && this.timeAttribute.length() > 0 && type.getDescriptor(this.timeAttribute) == null) {
                throw new DataSourceException("The provided name for the timeAttribute attribute is invalid.");
            }
            this.rasterManager = new RasterManager(this);
        }
        catch (Throwable e) {
            try {
                if (this.catalog != null) {
                    this.catalog.dispose();
                }
            }
            catch (Throwable e1) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, e1.getLocalizedMessage(), e1);
                }
            }
            finally {
                this.catalog = null;
            }
            try {
                if (this.rasterManager != null) {
                    this.rasterManager.dispose();
                }
            }
            catch (Throwable e1) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, e1.getLocalizedMessage(), e1);
                }
            }
            finally {
                this.rasterManager = null;
            }
            throw new DataSourceException(e);
        }
    }

    private void setGridGeometry(ReferencedEnvelope envelope) {
        Utilities.ensureNonNull((String)"index", (Object)this.catalog);
        BoundingBox bounds = this.catalog.getBounds();
        if (bounds.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a mosaic out of an empty index");
        }
        this.crs = bounds.getCoordinateReferenceSystem();
        if (envelope == null) {
            this.originalEnvelope = new GeneralEnvelope((Envelope)bounds);
        } else {
            this.originalEnvelope = new GeneralEnvelope((Envelope)envelope);
            this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        }
        this.originalGridRange = new GridEnvelope2D(new Rectangle((int)(this.originalEnvelope.getSpan(0) / this.highestRes[0]), (int)(this.originalEnvelope.getSpan(1) / this.highestRes[1])));
        this.raster2Model = new AffineTransform2D(this.highestRes[0], 0.0, 0.0, -this.highestRes[1], this.originalEnvelope.getLowerCorner().getOrdinate(0) + 0.5 * this.highestRes[0], this.originalEnvelope.getUpperCorner().getOrdinate(1) - 0.5 * this.highestRes[1]);
    }

    private void setGridGeometry() {
        this.setGridGeometry(null);
    }

    private MosaicConfigurationBean loadMosaicProperties() {
        File sourceFile = DataUtilities.urlToFile((URL)this.sourceURL);
        String extension = FilenameUtils.getExtension((String)sourceFile.getAbsolutePath());
        MosaicConfigurationBean configuration = null;
        if (extension.equalsIgnoreCase("shp")) {
            configuration = Utils.loadMosaicProperties(DataUtilities.changeUrlExt((URL)this.sourceURL, (String)"properties"), this.locationAttributeName);
        } else {
            File propFile;
            File[] properties;
            File[] arr$ = properties = sourceFile.getParentFile().listFiles((FilenameFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"indexer.properties")), (IOFileFilter)FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"datastore.properties")), (IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties")))));
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || Utils.checkFileReadable(propFile = arr$[i$]) && (configuration = Utils.loadMosaicProperties(DataUtilities.fileToURL((File)propFile), this.locationAttributeName)) != null); ++i$) {
            }
        }
        if (configuration != null) {
            return this.extractProperties(configuration);
        }
        return configuration;
    }

    private MosaicConfigurationBean extractProperties(MosaicConfigurationBean configuration) {
        String runtimeAttribute;
        String elevationAttribute;
        String timeAttribute;
        this.numOverviews = configuration.getLevelsNum() - 1;
        double[][] resolutions = configuration.getLevels();
        this.overViewResolutions = this.numOverviews >= 1 ? new double[this.numOverviews][2] : (double[][])null;
        this.highestRes = new double[2];
        this.highestRes[0] = resolutions[0][0];
        this.highestRes[1] = resolutions[0][1];
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Highest res " + this.highestRes[0] + " " + this.highestRes[1]);
        }
        if (this.numOverviews > 0) {
            for (int i = 0; i < this.numOverviews; ++i) {
                this.overViewResolutions[i][0] = resolutions[i + 1][0];
                this.overViewResolutions[i][1] = resolutions[i + 1][1];
            }
        }
        this.coverageName = configuration.getName();
        this.expandMe = configuration.isExpandToRGB();
        this.heterogeneousGranules = configuration.isHeterogeneous();
        this.pathType = configuration.isAbsolutePath() ? PathType.ABSOLUTE : PathType.RELATIVE;
        this.locationAttributeName = configuration.getLocationAttribute();
        String suggestedSPIClass = configuration.getSuggestedSPI();
        if (suggestedSPIClass != null) {
            try {
                Class<?> clazz = Class.forName(suggestedSPIClass);
                this.suggestedSPI = clazz.newInstance() instanceof ImageReaderSpi ? (ImageReaderSpi)clazz.newInstance() : null;
            }
            catch (ClassNotFoundException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                this.suggestedSPI = null;
            }
            catch (InstantiationException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                this.suggestedSPI = null;
            }
            catch (IllegalAccessException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                this.suggestedSPI = null;
            }
        }
        if ((timeAttribute = configuration.getTimeAttribute()) != null) {
            this.timeAttribute = timeAttribute;
        }
        if ((elevationAttribute = configuration.getElevationAttribute()) != null) {
            this.elevationAttribute = elevationAttribute;
        }
        if ((runtimeAttribute = configuration.getRuntimeAttribute()) != null) {
            this.runtimeAttribute = runtimeAttribute;
        }
        this.cachingIndex = configuration.isCaching();
        this.imposedBBox = true;
        return configuration;
    }

    public ImageMosaicReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImageMosaicFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        Collection<GridCoverage2D> response;
        if (this.rasterManager == null) {
            throw new IOException("Looks like this reader has been already disposed or it has not been properly initialized.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            if (this.sourceURL != null) {
                LOGGER.fine("Reading mosaic from " + this.sourceURL.toString());
            } else {
                LOGGER.fine("Reading mosaic");
            }
            LOGGER.fine("Highest res " + this.highestRes[0] + " " + this.highestRes[1]);
        }
        if (this.maxAllowedTiles != Integer.MAX_VALUE) {
            if (params != null) {
                boolean found = false;
                for (GeneralParameterValue pv : params) {
                    if (!pv.getDescriptor().getName().equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    GeneralParameterValue[] temp = new GeneralParameterValue[params.length + 1];
                    System.arraycopy(params, 0, temp, 0, params.length);
                    ParameterValue tempVal = ImageMosaicFormat.MAX_ALLOWED_TILES.createValue();
                    tempVal.setValue(this.maxAllowedTiles);
                    temp[params.length] = tempVal;
                }
            } else {
                ParameterValue tempVal = ImageMosaicFormat.MAX_ALLOWED_TILES.createValue();
                tempVal.setValue(this.maxAllowedTiles);
                params = new GeneralParameterValue[]{tempVal};
            }
        }
        if ((response = this.rasterManager.read(params)).isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("The response is empty. ==> returning a null GridCoverage");
            }
            return null;
        }
        return response.iterator().next();
    }

    Hints getHints() {
        return this.hints;
    }

    double[] getHighestRes() {
        return this.highestRes;
    }

    double[][] getOverviewsResolution() {
        return this.overViewResolutions;
    }

    int getNumberOfOvervies() {
        return this.numOverviews;
    }

    MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    GridCoverageFactory getGridCoverageFactory() {
        return this.coverageFactory;
    }

    String getName() {
        return this.coverageName;
    }

    public Object getDestination() {
        return null;
    }

    public void setCurrentSubname(String arg0) throws IOException {
        throw new UnsupportedOperationException("Unsupported method");
    }

    public void setMetadataValue(String arg0, String arg1) throws IOException {
        throw new UnsupportedOperationException("Unsupported method");
    }

    public void write(GridCoverage arg0, GeneralParameterValue[] arg1) throws IllegalArgumentException, IOException {
        throw new UnsupportedOperationException("Unsupported method");
    }

    public int getGridCoverageCount() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        super.dispose();
        try {
            if (this.rasterManager != null) {
                this.rasterManager.dispose();
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        finally {
            this.rasterManager = null;
        }
    }

    public String[] getMetadataNames() {
        String[] parentNames = super.getMetadataNames();
        ArrayList<String> metadataNames = new ArrayList<String>();
        metadataNames.add("TIME_DOMAIN");
        metadataNames.add("HAS_TIME_DOMAIN");
        metadataNames.add("TIME_DOMAIN_MINIMUM");
        metadataNames.add("TIME_DOMAIN_MAXIMUM");
        metadataNames.add("TIME_DOMAIN_RESOLUTION");
        metadataNames.add("ELEVATION_DOMAIN");
        metadataNames.add("ELEVATION_DOMAIN_MINIMUM");
        metadataNames.add("ELEVATION_DOMAIN_MAXIMUM");
        metadataNames.add("HAS_ELEVATION_DOMAIN");
        metadataNames.add("ELEVATION_DOMAIN_RESOLUTION");
        if (parentNames != null) {
            metadataNames.addAll(Arrays.asList(parentNames));
        }
        return metadataNames.toArray(new String[metadataNames.size()]);
    }

    public String getMetadataValue(String name) {
        boolean getElevationExtrema;
        boolean getElevationAttribute;
        boolean getTimeExtrema;
        boolean getTimeDomain;
        String superValue = super.getMetadataValue(name);
        if (superValue != null) {
            return superValue;
        }
        if (name.equalsIgnoreCase("HAS_ELEVATION_DOMAIN")) {
            return String.valueOf(this.elevationAttribute != null);
        }
        if (name.equalsIgnoreCase("HAS_TIME_DOMAIN")) {
            return String.valueOf(this.timeAttribute != null);
        }
        if (name.equalsIgnoreCase("TIME_DOMAIN_RESOLUTION")) {
            return null;
        }
        boolean bl = getTimeDomain = this.timeAttribute != null && name.equalsIgnoreCase("time_domain");
        if (getTimeDomain) {
            return this.extractTimeDomain();
        }
        boolean bl2 = getTimeExtrema = this.timeAttribute != null && (name.equalsIgnoreCase("time_domain_minimum") || name.equalsIgnoreCase("time_domain_maximum"));
        if (getTimeExtrema) {
            return this.extractTimeExtrema(name);
        }
        boolean bl3 = getElevationAttribute = this.elevationAttribute != null && name.equalsIgnoreCase("elevation_domain");
        if (getElevationAttribute) {
            return this.extractElevationDomain();
        }
        boolean bl4 = getElevationExtrema = this.elevationAttribute != null && (name.equalsIgnoreCase("elevation_domain_minimum") || name.equalsIgnoreCase("elevation_domain_maximum"));
        if (getElevationExtrema) {
            return this.extractElevationExtrema(name);
        }
        return super.getMetadataValue(name);
    }

    private String extractTimeExtrema(String metadataName) {
        if (this.timeAttribute == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Requesting extrema on attribute " + metadataName + " when no such an attribute is supported!");
            }
            return null;
        }
        try {
            FeatureCalc visitor = this.createExtremaQuery(metadataName, this.rasterManager.timeAttribute);
            java.util.Date result = (java.util.Date)visitor.getResult().getValue();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            df.setTimeZone(UTC_TZ);
            return df.format(result) + "Z";
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to compute extrema for TIME_DOMAIN", e);
            }
            return null;
        }
    }

    private FeatureCalc createExtremaQuery(String metadataName, String attributeName) throws IOException {
        Query query = new Query(this.rasterManager.granuleCatalog.getType().getTypeName());
        query.setPropertyNames(Arrays.asList(attributeName));
        MaxVisitor visitor = metadataName.toLowerCase().endsWith("maximum") ? new MaxVisitor(attributeName) : new MinVisitor(attributeName);
        this.rasterManager.granuleCatalog.computeAggregateFunction(query, (FeatureCalc)visitor);
        return visitor;
    }

    private String extractElevationExtrema(String metadataName) {
        if (this.elevationAttribute == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Requesting extrema on attribute " + metadataName + " when no such an attribute is supported!");
            }
            return null;
        }
        try {
            FeatureCalc visitor = this.createExtremaQuery(metadataName, this.rasterManager.elevationAttribute);
            Double result = (Double)visitor.getResult().getValue();
            return Double.toString(result);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to compute extrema for ELEVATION_DOMAIN", e);
            }
            return null;
        }
    }

    private String extractElevationDomain() {
        if (this.elevationAttribute == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Requesting domain on attribute elevation when no such an attribute is supported!");
            }
            return null;
        }
        try {
            Set result = this.extractDomain(this.elevationAttribute);
            if (result.size() <= 0) {
                return null;
            }
            StringBuilder buff = new StringBuilder();
            Iterator it = result.iterator();
            while (it.hasNext()) {
                double value = (Double)it.next();
                buff.append(value);
                if (!it.hasNext()) continue;
                buff.append(",");
            }
            return buff.toString();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to parse attribute: ELEVATION_DOMAIN", e);
            }
            return null;
        }
    }

    private Set extractDomain(String attribute) throws IOException {
        Set result;
        QueryCapabilities queryCapabilities = this.rasterManager.granuleCatalog.getQueryCapabilities();
        boolean manualSort = false;
        Query query = new Query(this.rasterManager.granuleCatalog.getType().getTypeName());
        query.setPropertyNames(Arrays.asList(attribute));
        SortBy[] sortBy = new SortBy[]{new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property(attribute), SortOrder.ASCENDING)};
        if (queryCapabilities.supportsSorting(sortBy)) {
            query.setSortBy(sortBy);
        } else {
            manualSort = true;
        }
        UniqueVisitor visitor = new UniqueVisitor(attribute);
        this.rasterManager.granuleCatalog.computeAggregateFunction(query, (FeatureCalc)visitor);
        Set set = result = manualSort ? new TreeSet(visitor.getUnique()) : visitor.getUnique();
        if (result.size() <= 0) {
            return null;
        }
        return result;
    }

    private String extractTimeDomain() {
        if (this.timeAttribute == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Requesting domain on attribute time when no such an attribute is supported!");
            }
            return null;
        }
        try {
            Set result = this.extractDomain(this.timeAttribute);
            if (result.size() <= 0) {
                return null;
            }
            StringBuilder buff = new StringBuilder();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            df.setTimeZone(UTC_TZ);
            for (java.util.Date date : result) {
                buff.append(df.format(date)).append("Z");
                buff.append(",");
            }
            return buff.substring(0, buff.length() - 1).toString();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to parse attribute:TIME_DOMAIN", e);
            }
            return null;
        }
    }
}

