/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.security.RolesFormComponent;
import org.geoserver.web.security.service.ServiceAccessRulePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceAccessRulePage
extends GeoServerSecuredPage {
    DropDownChoice service;
    DropDownChoice method;
    RolesFormComponent rolesForComponent;
    Form form;

    public AbstractServiceAccessRulePage(ServiceAccessRule rule) {
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)new ServiceAccessRule(rule)));
        this.form = new Form("ruleForm");
        this.add(new Component[]{this.form});
        Component[] componentArray = new Component[1];
        this.service = new DropDownChoice("service", this.getServiceNames());
        componentArray[0] = this.service;
        this.form.add(componentArray);
        this.service.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractServiceAccessRulePage.this.method.setChoices((IModel)new Model(AbstractServiceAccessRulePage.this.getMethod((String)AbstractServiceAccessRulePage.this.service.getConvertedInput())));
                AbstractServiceAccessRulePage.this.method.modelChanged();
                target.addComponent((Component)AbstractServiceAccessRulePage.this.method);
            }
        }});
        this.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.method = new DropDownChoice("method", this.getMethod(rule.getService()));
        componentArray2[0] = this.method;
        this.form.add(componentArray2);
        this.method.setOutputMarkupId(true);
        Component[] componentArray3 = new Component[1];
        this.rolesForComponent = new RolesFormComponent("roles", new RolesModel(rule), this.form, true);
        componentArray3[0] = this.rolesForComponent;
        this.form.add(componentArray3);
        this.form.add(new Component[]{new BookmarkablePageLink("cancel", ServiceAccessRulePage.class)});
        this.form.add(new Component[]{this.saveLink()});
        this.service.setRequired(true);
        this.method.setRequired(true);
    }

    SubmitLink saveLink() {
        return new SubmitLink("save"){

            public void onSubmit() {
                AbstractServiceAccessRulePage.this.onFormSubmit();
            }
        };
    }

    protected abstract void onFormSubmit();

    ArrayList<String> getServiceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Service ows : GeoServerExtensions.extensions(Service.class)) {
            if (result.contains(ows.getId())) continue;
            result.add(ows.getId());
        }
        Collections.sort(result);
        result.add(0, "*");
        return result;
    }

    ArrayList<String> getMethod(String service) {
        ArrayList<String> result = new ArrayList<String>();
        boolean flag = true;
        for (Service ows : GeoServerExtensions.extensions(Service.class)) {
            if (!service.equals(ows.getId()) || result.contains(ows.getOperations()) || !flag) continue;
            flag = false;
            result.addAll(ows.getOperations());
        }
        Collections.sort(result);
        result.add(0, "*");
        return result;
    }

    static class RolesModel
    implements IModel {
        ServiceAccessRule rule;

        RolesModel(ServiceAccessRule rule) {
            this.rule = rule;
        }

        public Object getObject() {
            return new ArrayList(this.rule.getRoles());
        }

        public void setObject(Object object) {
            this.rule.getRoles().clear();
            this.rule.getRoles().addAll((List)object);
        }

        public void detach() {
        }
    }
}

