/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.event.MapLayerEvent;
import org.geotools.map.event.MapLayerListener;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Layer {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.map");
    protected String title;
    protected boolean visible = true;
    protected Map<String, Object> userData;
    protected CopyOnWriteArrayList<MapLayerListener> listenerList;

    protected void fireMapLayerListenerLayerChanged(int eventType) {
        if (this.listenerList == null) {
            return;
        }
        MapLayerEvent event = new MapLayerEvent(this, eventType);
        for (MapLayerListener mapListener : this.listenerList) {
            try {
                mapListener.layerChanged(event);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Layer Event failure:" + t, t);
            }
        }
    }

    protected void fireMapLayerListenerLayerShown() {
        if (this.listenerList == null) {
            return;
        }
        MapLayerEvent event = new MapLayerEvent(this, 1);
        for (MapLayerListener mapListener : this.listenerList) {
            try {
                mapListener.layerShown(event);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Layer Event failure:" + t, t);
            }
        }
    }

    protected void fireMapLayerListenerLayerHidden() {
        if (this.listenerList == null) {
            return;
        }
        MapLayerEvent event = new MapLayerEvent(this, 1);
        for (MapLayerListener mapListener : this.listenerList) {
            try {
                mapListener.layerHidden(event);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Layer Event failure:" + t, t);
            }
        }
    }

    protected void fireMapLayerListenerLayerSelected() {
        if (this.listenerList == null) {
            return;
        }
        MapLayerEvent event = new MapLayerEvent(this, 1);
        for (MapLayerListener mapListener : this.listenerList) {
            try {
                mapListener.layerSelected(event);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Layer Event failure:" + t, t);
            }
        }
    }

    protected void fireMapLayerListenerLayerDeselected() {
        if (this.listenerList == null) {
            return;
        }
        MapLayerEvent event = new MapLayerEvent(this, 1);
        for (MapLayerListener mapListener : this.listenerList) {
            try {
                mapListener.layerDeselected(event);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Layer Event failure:" + t, t);
            }
        }
    }

    protected Layer() {
    }

    protected void finalize() throws Throwable {
        if (this.listenerList != null) {
            LOGGER.severe("Layer dispose not called; possible memory leak");
            this.dispose();
        }
        super.finalize();
    }

    public void dispose() {
        if (this.listenerList != null) {
            this.listenerList.clear();
            this.listenerList = null;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public synchronized Map<String, Object> getUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        return this.userData;
    }

    public abstract ReferencedEnvelope getBounds();

    public synchronized void addMapLayerListener(MapLayerListener listener) {
        boolean added;
        if (this.listenerList == null) {
            this.listenerList = new CopyOnWriteArrayList();
        }
        if ((added = this.listenerList.addIfAbsent(listener)) && this.listenerList.size() == 1) {
            this.connectDataListener(true);
        }
    }

    public synchronized void removeMapLayerListener(MapLayerListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(listener);
            if (this.listenerList.isEmpty()) {
                this.connectDataListener(false);
            }
        }
    }

    protected void connectDataListener(boolean listen) {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append("[");
        if (this.title != null && this.title.length() != 0) {
            buf.append(this.getTitle());
        }
        if (this.visible) {
            buf.append(", VISIBLE");
        } else {
            buf.append(", HIDDEN");
        }
        buf.append("]");
        return buf.toString();
    }
}

