/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapViewport {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.map");
    private Rectangle screenArea;
    private ReferencedEnvelope bounds;
    private CopyOnWriteArrayList<MapBoundsListener> boundsListeners;

    public void addMapBoundsListener(MapBoundsListener listener) {
        if (this.boundsListeners == null) {
            this.boundsListeners = new CopyOnWriteArrayList();
        }
        if (!this.boundsListeners.contains(listener)) {
            this.boundsListeners.add(listener);
        }
    }

    public void removeMapBoundsListener(MapBoundsListener listener) {
        if (this.boundsListeners != null) {
            this.boundsListeners.remove(listener);
        }
    }

    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    public CoordinateReferenceSystem getCoordianteReferenceSystem() {
        return this.bounds == null ? null : this.bounds.getCoordinateReferenceSystem();
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        if (this.bounds == null) {
            this.bounds = new ReferencedEnvelope(crs);
        } else if (this.bounds.getCoordinateReferenceSystem() != crs && this.bounds != null) {
            try {
                ReferencedEnvelope old = this.bounds;
                this.bounds = this.bounds.transform(crs, true);
                this.fireMapBoundsListenerMapBoundsChanged(MapBoundsEvent.Type.CRS, old, this.bounds);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Difficulty transforming to {0}", crs);
            }
        }
    }

    protected void fireMapBoundsListenerMapBoundsChanged(MapBoundsEvent.Type type, ReferencedEnvelope oldBounds, ReferencedEnvelope newBounds) {
        if (this.boundsListeners == null) {
            return;
        }
        if (newBounds == this.bounds) {
            newBounds = new ReferencedEnvelope(this.bounds);
        }
        MapBoundsEvent event = new MapBoundsEvent(this, type, oldBounds, newBounds);
        for (MapBoundsListener boundsListener : this.boundsListeners) {
            try {
                boundsListener.mapBoundsChanged(event);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.logp(Level.FINE, boundsListener.getClass().getName(), "mapBoundsChanged", t.getLocalizedMessage(), t);
            }
        }
    }

    public void setBounds(ReferencedEnvelope bounds) {
        ReferencedEnvelope old = this.bounds;
        this.bounds = bounds;
        this.fireMapBoundsListenerMapBoundsChanged(MapBoundsEvent.Type.BOUNDS, old, bounds);
    }

    public Rectangle getScreenArea() {
        return this.screenArea;
    }

    public void setScreenArea(Rectangle screenArea) {
        this.screenArea = screenArea;
    }

    public void transform(AffineTransform transform) {
        ReferencedEnvelope old = this.bounds;
        double[] coords = new double[]{this.bounds.getMinX(), this.bounds.getMinY(), this.bounds.getMaxX(), this.bounds.getMaxY()};
        transform.transform(coords, 0, coords, 0, 2);
        this.bounds = new ReferencedEnvelope(coords[0], coords[2], coords[1], coords[3], this.bounds.getCoordinateReferenceSystem());
        this.fireMapBoundsListenerMapBoundsChanged(MapBoundsEvent.Type.BOUNDS, old, this.bounds);
    }
}

