/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import com.vividsolutions.jts.geom.Geometry;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.style.DynamicLineStyle2D;
import org.geotools.renderer.style.DynamicPolygonStyle2D;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.renderer.style.FontCache;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.RescaledIcon;
import org.geotools.renderer.style.Style;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleAttributeExtractorTruncated;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.util.Range;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.GraphicalSymbol;

public class SLDStyleFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    private static final int MAX_RASTERIZATION_SIZE = 512;
    private static final Map joinLookup = new HashMap();
    private static final Map capLookup = new HashMap();
    private static final Map fontStyleLookup = new HashMap();
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private static final Canvas obs = new Canvas();
    Map dynamicSymbolizers = new SoftValueHashMap();
    Map staticSymbolizers = new SoftValueHashMap();
    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    private boolean lineOptimizationEnabled = false;
    private boolean vectorRenderingEnabled = false;
    private long hits;
    private long requests;
    private double mapScaleDenominator = Double.NaN;

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints == null) {
            return;
        }
        this.renderingHints = renderingHints;
    }

    public boolean isLineOptimizationEnabled() {
        return this.lineOptimizationEnabled;
    }

    public void setLineOptimizationEnabled(boolean lineOptimizationEnabled) {
        this.lineOptimizationEnabled = lineOptimizationEnabled;
    }

    public boolean isVectorRenderingEnabled() {
        return this.vectorRenderingEnabled;
    }

    public void setVectorRenderingEnabled(boolean vectorRenderingEnabled) {
        this.vectorRenderingEnabled = vectorRenderingEnabled;
    }

    public double getHitRatio() {
        return (double)this.hits / (double)this.requests;
    }

    public long getHits() {
        return this.hits;
    }

    public long getRequests() {
        return this.requests;
    }

    public Style2D createStyle(Object drawMe, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        SymbolizerKey key = new SymbolizerKey(symbolizer, scaleRange);
        style = (Style2D)this.staticSymbolizers.get(key);
        ++this.requests;
        if (style != null) {
            ++this.hits;
        } else {
            boolean noAttributes;
            style = this.createStyleInternal(drawMe, symbolizer, scaleRange);
            if (style == null) {
                return null;
            }
            if (this.dynamicSymbolizers.containsKey(key)) {
                return style;
            }
            StyleAttributeExtractorTruncated sae = new StyleAttributeExtractorTruncated();
            sae.visit(symbolizer);
            Set<String> nameSet = sae.getAttributeNameSet();
            boolean bl = noAttributes = nameSet == null || nameSet.size() == 0;
            if (noAttributes && !sae.isUsingVolatileFunctions()) {
                this.staticSymbolizers.put(key, style);
            } else {
                this.dynamicSymbolizers.put(key, Boolean.TRUE);
            }
        }
        return style;
    }

    private Style2D createStyleInternal(Object drawMe, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        if (symbolizer instanceof PolygonSymbolizer) {
            style = this.createPolygonStyle(drawMe, (PolygonSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof LineSymbolizer) {
            style = this.createLineStyle(drawMe, (LineSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof PointSymbolizer) {
            style = this.createPointStyle(drawMe, (PointSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof TextSymbolizer) {
            style = this.createTextStyle(drawMe, (TextSymbolizer)symbolizer, scaleRange);
        }
        return style;
    }

    public Style2D createDynamicStyle(SimpleFeature f, Symbolizer symbolizer, Range scaleRange) {
        Style2D style = null;
        if (symbolizer instanceof PolygonSymbolizer) {
            style = this.createDynamicPolygonStyle(f, (PolygonSymbolizer)symbolizer, scaleRange);
        } else if (symbolizer instanceof LineSymbolizer) {
            style = this.createDynamicLineStyle(f, (LineSymbolizer)symbolizer, scaleRange);
        } else {
            throw new UnsupportedOperationException("This kind of symbolizer is not yet supported");
        }
        return style;
    }

    PolygonStyle2D createPolygonStyle(Object feature, PolygonSymbolizer symbolizer, Range scaleRange) {
        PolygonStyle2D style = new PolygonStyle2D();
        this.setScaleRange(style, scaleRange);
        style.setStroke(this.getStroke(symbolizer.getStroke(), feature));
        style.setGraphicStroke(this.getGraphicStroke(symbolizer.getStroke(), feature, scaleRange));
        style.setContour(this.getStrokePaint(symbolizer.getStroke(), feature));
        style.setContourComposite(this.getStrokeComposite(symbolizer.getStroke(), feature));
        this.setPolygonStyleFill(feature, style, symbolizer, scaleRange);
        return style;
    }

    void setPolygonStyleFill(Object feature, PolygonStyle2D style, PolygonSymbolizer symbolizer, Range scaleRange) {
        Fill fill = symbolizer.getFill();
        if (fill == null) {
            return;
        }
        if (fill.getGraphicFill() != null) {
            double size = this.evalToDouble(fill.getGraphicFill().getSize(), feature, 0.0);
            if (this.isVectorRenderingEnabled() || size > 512.0) {
                Style2D style2DFill = this.createPointStyle(feature, fill.getGraphicFill(), scaleRange, false);
                style.setGraphicFill(style2DFill);
                return;
            }
        }
        style.setFill(this.getPaint(symbolizer.getFill(), feature));
        style.setFillComposite(this.getComposite(symbolizer.getFill(), feature));
    }

    Style2D createDynamicPolygonStyle(SimpleFeature feature, PolygonSymbolizer symbolizer, Range scaleRange) {
        DynamicPolygonStyle2D style = new DynamicPolygonStyle2D(feature, symbolizer);
        this.setScaleRange(style, scaleRange);
        return style;
    }

    Style2D createLineStyle(Object feature, LineSymbolizer symbolizer, Range scaleRange) {
        LineStyle2D style = new LineStyle2D();
        this.setScaleRange(style, scaleRange);
        style.setStroke(this.getStroke(symbolizer.getStroke(), feature));
        style.setGraphicStroke(this.getGraphicStroke(symbolizer.getStroke(), feature, scaleRange));
        style.setContour(this.getStrokePaint(symbolizer.getStroke(), feature));
        style.setContourComposite(this.getStrokeComposite(symbolizer.getStroke(), feature));
        return style;
    }

    Style2D createDynamicLineStyle(SimpleFeature feature, LineSymbolizer symbolizer, Range scaleRange) {
        DynamicLineStyle2D style = new DynamicLineStyle2D(feature, symbolizer);
        this.setScaleRange(style, scaleRange);
        return style;
    }

    Style2D createPointStyle(Object feature, PointSymbolizer symbolizer, Range scaleRange) {
        return this.createPointStyle(feature, symbolizer.getGraphic(), scaleRange, false);
    }

    Style2D createPointStyle(Object feature, Graphic sldGraphic, Range scaleRange, boolean forceVector) {
        Style2D retval = null;
        float opacity = this.evalOpacity(sldGraphic.getOpacity(), feature);
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        float displacementX = 0.0f;
        float displacementY = 0.0f;
        if (sldGraphic.getDisplacement() != null) {
            displacementX = this.evalToFloat(sldGraphic.getDisplacement().getDisplacementX(), feature, 0.0f);
            displacementY = this.evalToFloat(sldGraphic.getDisplacement().getDisplacementY(), feature, 0.0f);
        }
        double size = 0.0;
        try {
            if (sldGraphic.getSize() != null && !Expression.NIL.equals(sldGraphic.getSize())) {
                size = this.evalToDouble(sldGraphic.getSize(), feature, 0.0);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        float rotation = (float)((double)this.evalToFloat(sldGraphic.getRotation(), feature, 0.0f) * Math.PI / 180.0);
        List<GraphicalSymbol> symbols = sldGraphic.graphicalSymbols();
        if (symbols.isEmpty()) {
            symbols = new ArrayList<GraphicalSymbol>();
            Mark square = StyleFactoryFinder.createStyleFactory().createMark();
            symbols.add(square);
        }
        int length = symbols.size();
        Object img = null;
        for (GraphicalSymbol symbol : symbols) {
            Mark mark;
            Shape shape;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("trying to render symbol " + symbol);
            }
            if (symbol instanceof ExternalGraphic) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("rendering External graphic");
                }
                ExternalGraphic eg = (ExternalGraphic)symbol;
                if (this.vectorRenderingEnabled || forceVector || size > 512.0) {
                    Icon icon = this.getIcon(eg, feature, -1.0);
                    if (icon == null) continue;
                    if (icon instanceof ImageIcon) {
                        GraphicStyle2D g2d = this.getGraphicStyle(eg, (Feature)feature, size, 1);
                        if (g2d == null) continue;
                        g2d.setRotation(rotation);
                        g2d.setOpacity(opacity);
                        retval = g2d;
                        break;
                    }
                    if ((double)icon.getIconHeight() != size && size != 0.0) {
                        double scale = size / (double)icon.getIconHeight();
                        icon = new RescaledIcon(icon, scale);
                    }
                    retval = new IconStyle2D(icon, feature, displacementX, displacementY, rotation, composite);
                    break;
                }
                GraphicStyle2D g2d = this.getGraphicStyle(eg, (Feature)feature, size, 1);
                if (g2d == null) continue;
                g2d.setRotation(rotation);
                g2d.setOpacity(opacity);
                retval = g2d;
                break;
            }
            if (!(symbol instanceof Mark)) continue;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("rendering mark @ PointRenderer " + symbol.toString());
            }
            if ((shape = this.getShape(mark = (Mark)symbol, feature)) == null) {
                throw new IllegalArgumentException("The specified mark " + mark.getWellKnownName() + " was not found!");
            }
            MarkStyle2D ms2d = new MarkStyle2D();
            ms2d.setShape(shape);
            ms2d.setFill(this.getPaint(mark.getFill(), feature));
            ms2d.setFillComposite(this.getComposite(mark.getFill(), feature));
            ms2d.setStroke(this.getStroke(mark.getStroke(), feature));
            ms2d.setContour(this.getStrokePaint(mark.getStroke(), feature));
            ms2d.setContourComposite(this.getStrokeComposite(mark.getStroke(), feature));
            if (size <= 0.0) {
                size = 16.0;
            }
            ms2d.setSize((int)size);
            ms2d.setRotation(rotation);
            retval = ms2d;
            break;
        }
        if (retval != null) {
            this.setScaleRange(retval, scaleRange);
        }
        return retval;
    }

    int toImageSize(double size) {
        if (size == -1.0) {
            return -1;
        }
        if (size > 0.0 && size < 0.5) {
            return 1;
        }
        return (int)Math.round(size);
    }

    Style2D createTextStyle(Object feature, TextSymbolizer symbolizer, Range scaleRange) {
        LabelPlacement p;
        TextStyle2D ts2d = new TextStyle2D();
        this.setScaleRange(ts2d, scaleRange);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("creating text style");
        }
        String geomName = symbolizer.getGeometryPropertyName();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("geomName = " + geomName);
        }
        String label = this.evalToString(symbolizer.getLabel(), feature, "");
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("label is " + label);
        }
        ts2d.setLabel(label);
        org.geotools.styling.Font[] fonts = symbolizer.getFonts();
        Font javaFont = this.getFont(feature, fonts);
        ts2d.setFont(javaFont);
        LabelPlacement placement = symbolizer.getLabelPlacement();
        double anchorX = 0.0;
        double anchorY = 0.0;
        double rotation = 0.0;
        double dispX = 0.0;
        double dispY = 0.0;
        if (placement instanceof PointPlacement) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("setting pointPlacement");
            }
            if ((p = (PointPlacement)placement).getAnchorPoint() != null) {
                anchorX = this.evalToDouble(p.getAnchorPoint().getAnchorPointX(), feature, 0.0);
                anchorY = this.evalToDouble(p.getAnchorPoint().getAnchorPointY(), feature, 0.5);
            }
            if (p.getDisplacement() != null) {
                dispX = this.evalToDouble(p.getDisplacement().getDisplacementX(), feature, 0.0);
                dispY = this.evalToDouble(p.getDisplacement().getDisplacementY(), feature, 0.0);
            }
            if (symbolizer instanceof TextSymbolizer2 && ((TextSymbolizer2)symbolizer).getGraphic() != null) {
                rotation = 0.0;
            } else {
                rotation = this.evalToDouble(p.getRotation(), feature, 0.0);
                rotation *= Math.PI / 180;
            }
            ts2d.setPointPlacement(true);
        } else if (placement instanceof LinePlacement) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("setting pointPlacement");
            }
            ts2d.setPointPlacement(false);
            p = (LinePlacement)placement;
            int displace = this.evalToInt(p.getPerpendicularOffset(), feature, 0);
            ts2d.setPerpendicularOffset(displace);
        }
        ts2d.setAnchorX(anchorX);
        ts2d.setAnchorY(anchorY);
        ts2d.setRotation((float)rotation);
        ts2d.setDisplacementX(dispX);
        ts2d.setDisplacementY(dispY);
        ts2d.setFill(this.getPaint(symbolizer.getFill(), feature));
        ts2d.setComposite(this.getComposite(symbolizer.getFill(), feature));
        Halo halo = symbolizer.getHalo();
        if (halo != null) {
            ts2d.setHaloFill(this.getPaint(halo.getFill(), feature));
            ts2d.setHaloComposite(this.getComposite(halo.getFill(), feature));
            ts2d.setHaloRadius(this.evalToFloat(halo.getRadius(), feature, 1.0f));
        }
        Graphic graphicShield = null;
        if (symbolizer instanceof TextSymbolizer2 && (graphicShield = ((TextSymbolizer2)symbolizer).getGraphic()) != null) {
            Style2D shieldStyle = this.createPointStyle(feature, graphicShield, scaleRange, true);
            ts2d.setGraphic(shieldStyle);
        }
        return ts2d;
    }

    private Geometry findGeometry(Object feature, String geomName) {
        Object geom = null;
        if (geomName == null) {
            geomName = "";
        }
        PropertyName property = ff.property(geomName);
        return (Geometry)property.evaluate(feature, Geometry.class);
    }

    private Font getFont(Object feature, org.geotools.styling.Font[] fonts) {
        if (fonts != null) {
            for (int k = 0; k < fonts.length; ++k) {
                String requestedFont = this.evalToString(fonts[k].getFontFamily(), feature, null);
                Font javaFont = FontCache.getDefaultInstance().getFont(requestedFont);
                if (javaFont == null) continue;
                String reqStyle = this.evalToString(fonts[k].getFontStyle(), feature, null);
                int styleCode = fontStyleLookup.containsKey(reqStyle) ? (Integer)fontStyleLookup.get(reqStyle) : 0;
                String reqWeight = this.evalToString(fonts[k].getFontWeight(), feature, null);
                if ("Bold".equalsIgnoreCase(reqWeight)) {
                    styleCode |= 1;
                }
                int size = this.evalToInt(fonts[k].getFontSize(), feature, 10);
                return javaFont.deriveFont(styleCode, size);
            }
        }
        return new Font("Serif", 0, 12);
    }

    void setScaleRange(Style style, Range scaleRange) {
        double min = ((Number)((Object)scaleRange.getMinValue())).doubleValue();
        double max = ((Number)((Object)scaleRange.getMaxValue())).doubleValue();
        style.setMinMaxScale(min, max);
    }

    private Style2D getGraphicStroke(Stroke stroke, Object feature, Range scaleRange) {
        if (stroke == null || stroke.getGraphicStroke() == null) {
            return null;
        }
        return this.createPointStyle(feature, stroke.getGraphicStroke(), scaleRange, false);
    }

    private java.awt.Stroke getStroke(Stroke stroke, Object feature) {
        if (stroke == null) {
            return null;
        }
        String joinType = this.evalToString(stroke.getLineJoin(), feature, "miter");
        int joinCode = joinLookup.containsKey(joinType) ? (Integer)joinLookup.get(joinType) : 0;
        String capType = this.evalToString(stroke.getLineCap(), feature, "square");
        int capCode = capLookup.containsKey(capType) ? (Integer)capLookup.get(capType) : 2;
        float[] dashes = stroke.getDashArray();
        float width = this.evalToFloat(stroke.getWidth(), feature, 1.0f);
        float dashOffset = this.evalToFloat(stroke.getDashOffset(), feature, 0.0f);
        if ((double)width < 1.5 & this.lineOptimizationEnabled) {
            width = 0.0f;
        }
        BasicStroke stroke2d = dashes != null && dashes.length > 0 ? new BasicStroke(width, capCode, joinCode, 1.0f, dashes, dashOffset) : new BasicStroke(width, capCode, joinCode, 1.0f);
        return stroke2d;
    }

    private Paint getStrokePaint(Stroke stroke, Object feature) {
        if (stroke == null) {
            return null;
        }
        Paint contourPaint = this.evalToColor(stroke.getColor(), feature, Color.BLACK);
        Graphic gr = stroke.getGraphicFill();
        if (gr != null) {
            contourPaint = this.getTexturePaint(gr, feature);
        }
        return contourPaint;
    }

    private Composite getStrokeComposite(Stroke stroke, Object feature) {
        if (stroke == null) {
            return null;
        }
        float opacity = this.evalOpacity(stroke.getOpacity(), feature);
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        return composite;
    }

    protected Paint getPaint(Fill fill, Object feature) {
        if (fill == null) {
            return null;
        }
        Paint fillPaint = this.evalToColor(fill.getColor(), feature, null);
        Graphic gr = fill.getGraphicFill();
        if (gr != null) {
            fillPaint = this.getTexturePaint(gr, feature);
        }
        return fillPaint;
    }

    protected Composite getComposite(Fill fill, Object feature) {
        if (fill == null) {
            return null;
        }
        float opacity = this.evalOpacity(fill.getOpacity(), feature);
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        return composite;
    }

    public TexturePaint getTexturePaint(Graphic gr, Object feature) {
        int iSizeY;
        int iSizeX;
        ExternalGraphic eg;
        double graphicSize = this.evalToDouble(gr.getSize(), feature, -1.0);
        GraphicStyle2D gs = null;
        ExternalGraphic[] arr$ = gr.getExternalGraphics();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (gs = this.getGraphicStyle(eg = arr$[i$], feature, graphicSize, 1)) == null; ++i$) {
        }
        BufferedImage image = null;
        if (gs != null) {
            image = gs.getImage();
            iSizeX = image.getWidth() - gs.getBorder();
            iSizeY = image.getHeight() - gs.getBorder();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("got an image in graphic fill");
            }
        } else {
            Mark mark;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("going for the mark from graphic fill");
            }
            if ((mark = this.getMark(gr, feature)) == null) {
                return null;
            }
            Shape shape = this.getShape(mark, feature);
            if (shape == null) {
                return null;
            }
            Rectangle2D shapeBounds = shape.getBounds2D();
            double shapeAspectRatio = shapeBounds.getHeight() > 0.0 && shapeBounds.getWidth() > 0.0 ? shapeBounds.getWidth() / shapeBounds.getHeight() : 1.0;
            int size = this.evalToInt(gr.getSize(), feature, 16);
            double sizeX = (double)size * shapeAspectRatio;
            double sizeY = size;
            image = new BufferedImage((int)Math.ceil(sizeX * 3.0), (int)Math.ceil(sizeY * 3.0), 2);
            Graphics2D g2d = image.createGraphics();
            g2d.setRenderingHints(this.renderingHints);
            double rotation = this.evalToDouble(gr.getRotation(), feature, 0.0);
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    double tx = sizeX * 1.5 + sizeX * (double)i;
                    double ty = sizeY * 1.5 + sizeY * (double)j;
                    this.fillDrawMark(g2d, tx, ty, mark, size, rotation, feature);
                }
            }
            g2d.dispose();
            iSizeX = (int)Math.floor(sizeX);
            iSizeY = (int)Math.floor(sizeY);
            image = image.getSubimage(iSizeX, iSizeY, iSizeX + 1, iSizeY + 1);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, iSizeX, iSizeY);
        TexturePaint imagePaint = new TexturePaint(image, rect);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("applied TexturePaint " + imagePaint);
        }
        return imagePaint;
    }

    private GraphicStyle2D getGraphicStyle(ExternalGraphic eg, Object feature, double size, int border) {
        Icon icon = this.getIcon(eg, feature, this.toImageSize(size));
        if (icon != null) {
            ImageIcon img;
            if (icon instanceof ImageIcon && (img = (ImageIcon)icon).getImage() instanceof BufferedImage) {
                BufferedImage image = (BufferedImage)img.getImage();
                return new GraphicStyle2D(image, 0.0f, 0.0f);
            }
            BufferedImage result = new BufferedImage(icon.getIconWidth() + border * 2, icon.getIconHeight() + border * 2, 6);
            Graphics2D g = (Graphics2D)result.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            icon.paintIcon(null, g, 1, 1);
            g.dispose();
            return new GraphicStyle2D(result, 0.0f, 0.0f, border);
        }
        return null;
    }

    private Icon getIcon(ExternalGraphic eg, Object feature, double size) {
        Expression location;
        String strLocation;
        if (eg == null) {
            return null;
        }
        try {
            strLocation = eg.getLocation().toExternalForm();
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.INFO, "Malformed URL processing external graphic", e);
            return null;
        }
        try {
            location = ExpressionExtractor.extractCqlExpressions(strLocation);
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Could not parse cql expressions out of " + strLocation, e);
            }
            location = ff.literal((Object)strLocation);
        }
        Iterator<ExternalGraphicFactory> it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
        while (it.hasNext()) {
            try {
                Expression formatExpression = ExpressionExtractor.extractCqlExpressions(eg.getFormat());
                String format = (String)formatExpression.evaluate(feature, String.class);
                Icon icon = it.next().getIcon((Feature)feature, location, format, this.toImageSize(size));
                if (icon == null) continue;
                return icon;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error occurred evaluating external graphic", e);
            }
        }
        return null;
    }

    private Mark getMark(Graphic graphic, Object feature) {
        if (graphic == null) {
            return null;
        }
        Mark[] marks = graphic.getMarks();
        for (int i = 0; i < marks.length; ++i) {
            Mark mark = marks[i];
            Shape shape = this.getShape(mark, feature);
            if (shape == null) continue;
            return mark;
        }
        return null;
    }

    private Shape getShape(Mark mark, Object feature) {
        String expression;
        if (mark == null) {
            return null;
        }
        Expression name = mark.getWellKnownName();
        if (name instanceof Literal && (expression = this.evalToString(name, null, null)) != null) {
            name = ExpressionExtractor.extractCqlExpressions(expression);
        }
        Iterator<MarkFactory> it = DynamicSymbolFactoryFinder.getMarkFactories();
        while (it.hasNext()) {
            MarkFactory factory = it.next();
            try {
                Shape shape = factory.getShape(null, name, (Feature)feature);
                if (shape == null) continue;
                return shape;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception while scanning for the appropriate mark factory", e);
            }
        }
        return null;
    }

    private void fillDrawMark(Graphics2D g2d, double tx, double ty, Mark mark, double size, double rotation, Object feature) {
        if (mark == null) {
            return;
        }
        Shape originalShape = this.getShape(mark, feature);
        AffineTransform markAT = new AffineTransform();
        markAT.translate(tx, ty);
        markAT.rotate(rotation);
        markAT.scale(size, -size);
        Shape shape = markAT.createTransformedShape(originalShape);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (mark.getFill() != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying fill to mark");
            }
            g2d.setPaint(this.getPaint(mark.getFill(), feature));
            g2d.setComposite(this.getComposite(mark.getFill(), feature));
            g2d.fill(shape);
        }
        if (mark.getStroke() != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("applying stroke to mark");
            }
            g2d.setPaint(this.getStrokePaint(mark.getStroke(), feature));
            g2d.setComposite(this.getStrokeComposite(mark.getStroke(), feature));
            g2d.setStroke(this.getStroke(mark.getStroke(), feature));
            g2d.draw(shape);
        }
    }

    public static int lookUpJoin(String joinType) {
        if (joinLookup.containsKey(joinType)) {
            return (Integer)joinLookup.get(joinType);
        }
        return 0;
    }

    public static int lookUpCap(String capType) {
        if (capLookup.containsKey(capType)) {
            return (Integer)capLookup.get(capType);
        }
        return 2;
    }

    public double getMapScaleDenominator() {
        return this.mapScaleDenominator;
    }

    public void setMapScaleDenominator(double mapScaleDenominator) {
        this.mapScaleDenominator = mapScaleDenominator;
    }

    private String evalToString(Expression exp, Object f, String fallback) {
        if (exp == null) {
            return fallback;
        }
        String s = (String)exp.evaluate(f, String.class);
        if (s != null) {
            return s;
        }
        return fallback;
    }

    private float evalToFloat(Expression exp, Object f, float fallback) {
        if (exp == null) {
            return fallback;
        }
        Float fo = (Float)exp.evaluate(f, Float.class);
        if (fo != null) {
            return fo.floatValue();
        }
        return fallback;
    }

    private double evalToDouble(Expression exp, Object f, double fallback) {
        if (exp == null) {
            return fallback;
        }
        Double d = (Double)exp.evaluate(f, Double.class);
        if (d != null) {
            return d;
        }
        return fallback;
    }

    private int evalToInt(Expression exp, Object f, int fallback) {
        if (exp == null) {
            return fallback;
        }
        Integer i = (Integer)exp.evaluate(f, Integer.class);
        if (i != null) {
            return i;
        }
        return fallback;
    }

    private Color evalToColor(Expression exp, Object f, Color fallback) {
        if (exp == null) {
            return fallback;
        }
        Color color = (Color)exp.evaluate(f, Color.class);
        if (color != null) {
            return color;
        }
        return fallback;
    }

    private float evalOpacity(Expression e, Object f) {
        return this.evalToFloat(e, f, 1.0f);
    }

    static {
        joinLookup.put("miter", new Integer(0));
        joinLookup.put("bevel", new Integer(2));
        joinLookup.put("round", new Integer(1));
        capLookup.put("butt", new Integer(0));
        capLookup.put("round", new Integer(1));
        capLookup.put("square", new Integer(2));
        fontStyleLookup.put("normal", new Integer(0));
        fontStyleLookup.put("italic", new Integer(2));
        fontStyleLookup.put("oblique", new Integer(2));
        fontStyleLookup.put("bold", new Integer(1));
    }

    static class SymbolizerKey {
        private Symbolizer symbolizer;
        private double minScale;
        private double maxScale;

        public SymbolizerKey(Symbolizer symbolizer, Range scaleRange) {
            this.symbolizer = symbolizer;
            this.minScale = ((Number)((Object)scaleRange.getMinValue())).doubleValue();
            this.maxScale = ((Number)((Object)scaleRange.getMaxValue())).doubleValue();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SymbolizerKey)) {
                return false;
            }
            SymbolizerKey other = (SymbolizerKey)obj;
            return other.symbolizer == this.symbolizer && other.minScale == this.minScale && other.maxScale == this.maxScale;
        }

        public int hashCode() {
            return ((17 + System.identityHashCode(this.symbolizer)) * 37 + this.doubleHash(this.minScale)) * 37 + this.doubleHash(this.maxScale);
        }

        private int doubleHash(double value) {
            long bits = Double.doubleToLongBits(value);
            return (int)(bits ^ bits >>> 32);
        }
    }
}

