/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.styling.Font;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.VolatileFunction;

public class StyleAttributeExtractorTruncated
extends StyleAttributeExtractor
implements StyleVisitor {
    boolean usingVolatileFunctions = false;

    public void clear() {
        super.clear();
        this.usingVolatileFunctions = false;
    }

    public boolean isUsingVolatileFunctions() {
        return this.usingVolatileFunctions;
    }

    public Object visit(Function expression, Object data) {
        this.usingVolatileFunctions |= expression instanceof VolatileFunction;
        return super.visit(expression, data);
    }

    public void visit(RasterSymbolizer rs) {
        if (rs != null) {
            if (rs.getImageOutline() != null) {
                rs.getImageOutline().accept(this);
            }
            if (rs.getOpacity() != null) {
                rs.getOpacity().accept((ExpressionVisitor)this, null);
            }
        }
    }

    public void visit(PointSymbolizer ps) {
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept(this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (line.getStroke() != null) {
            line.getStroke().accept(this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (poly.getStroke() != null) {
            poly.getStroke().accept(this);
        }
        if (poly.getFill() != null) {
            poly.getFill().accept(this);
        }
    }

    public void visit(TextSymbolizer text) {
        if (text instanceof TextSymbolizer2 && ((TextSymbolizer2)text).getGraphic() != null) {
            ((TextSymbolizer2)text).getGraphic().accept(this);
        }
        if (text.getFill() != null) {
            text.getFill().accept(this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept(this);
        }
        if (text.getFonts() != null) {
            Font[] fonts = text.getFonts();
            for (int i = 0; i < fonts.length; ++i) {
                Font font = fonts[i];
                if (font.getFontFamily() != null) {
                    font.getFontFamily().accept((ExpressionVisitor)this, null);
                }
                if (font.getFontSize() != null) {
                    font.getFontSize().accept((ExpressionVisitor)this, null);
                }
                if (font.getFontStyle() != null) {
                    font.getFontStyle().accept((ExpressionVisitor)this, null);
                }
                if (font.getFontWeight() == null) continue;
                font.getFontWeight().accept((ExpressionVisitor)this, null);
            }
        }
        if (text.getHalo() != null) {
            text.getHalo().accept(this);
        }
        if (text.getPlacement() != null) {
            text.getPlacement().accept(this);
        }
    }
}

