/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.io.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.geotools.graph.build.GraphBuilder;
import org.geotools.graph.io.standard.AbstractReaderWriter;
import org.geotools.graph.io.standard.FileReaderWriter;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Node;

public class SerializedReaderWriter
extends AbstractReaderWriter
implements FileReaderWriter {
    public Graph read() throws Exception {
        GraphBuilder builder = (GraphBuilder)this.getProperty("BUILDER");
        ObjectInputStream objin = new ObjectInputStream(new BufferedInputStream(new FileInputStream((String)this.getProperty("FILENAME"))));
        int nnodes = objin.readInt();
        int nedges = objin.readInt();
        int count = 0;
        while (count++ < nedges) {
            Edge e = (Edge)objin.readObject();
            e.getNodeA().setVisited(false);
            e.getNodeB().setVisited(false);
            builder.addEdge(e);
        }
        for (Edge e : builder.getGraph().getEdges()) {
            if (!e.getNodeA().isVisited()) {
                e.getNodeA().setVisited(true);
                builder.addNode(e.getNodeA());
            }
            if (e.getNodeB().isVisited()) continue;
            e.getNodeB().setVisited(true);
            builder.addNode(e.getNodeB());
        }
        try {
            Node n;
            while ((n = (Node)objin.readObject()) != null) {
                builder.addNode(n);
            }
        }
        catch (EOFException ignore) {
            // empty catch block
        }
        return builder.getGraph();
    }

    public void write(Graph graph) throws Exception {
        ObjectOutputStream objout = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((String)this.getProperty("FILENAME"))));
        objout.writeInt(graph.getNodes().size());
        objout.writeInt(graph.getEdges().size());
        for (Edge e : graph.getEdges()) {
            objout.writeObject(e);
        }
        for (Node n : graph.getNodesOfDegree(0)) {
            objout.writeObject(n);
        }
        objout.flush();
        objout.close();
    }
}

