/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.opt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.opt.OptGraphable;

public class OptNode
extends OptGraphable
implements Node {
    private Edge[] m_edges;

    public OptNode() {
        this(0);
    }

    public OptNode(int degree) {
        this.m_edges = new Edge[degree];
    }

    public void add(Edge e) {
        for (int i = 0; i < this.m_edges.length; ++i) {
            if (this.m_edges[i] != null) continue;
            this.m_edges[i] = e;
            return;
        }
    }

    public void remove(Edge e) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#remove(Edge)");
    }

    public Edge getEdge(Node other) {
        for (int i = 0; i < this.m_edges.length; ++i) {
            if ((!this.m_edges[i].getNodeA().equals(this) || !this.m_edges[i].getNodeB().equals(other)) && (!this.m_edges[i].getNodeB().equals(this) || !this.m_edges[i].getNodeA().equals(other))) continue;
            return this.m_edges[i];
        }
        return null;
    }

    public List getEdges(Node other) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int i = 0; i < this.m_edges.length; ++i) {
            if ((!this.m_edges[i].getNodeA().equals(this) || !this.m_edges[i].getNodeB().equals(other)) && (!this.m_edges[i].getNodeB().equals(this) || !this.m_edges[i].getNodeA().equals(other))) continue;
            edges.add(this.m_edges[i]);
        }
        return edges;
    }

    public Edge[] getEdgeArray() {
        return this.m_edges;
    }

    public List getEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int i = 0; i < this.m_edges.length; ++i) {
            edges.add(this.m_edges[i]);
        }
        return edges;
    }

    public void setDegree(int degree) {
        this.m_edges = new Edge[degree];
    }

    public int getDegree() {
        return this.m_edges.length;
    }

    public Iterator getRelated() {
        return new RelatedIterator(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setDegree(in.readInt());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.getDegree());
    }

    public class RelatedIterator
    implements Iterator {
        private byte m_index = 0;
        private OptNode m_node;

        public RelatedIterator(OptNode node) {
            this.m_node = node;
        }

        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName() + "#remove()");
        }

        public boolean hasNext() {
            return this.m_index < OptNode.this.m_edges.length;
        }

        public Object next() {
            byte by = this.m_index;
            this.m_index = (byte)(by + 1);
            Edge e = OptNode.this.m_edges[by];
            return e.getNodeA().equals(this.m_node) ? e.getNodeB() : e.getNodeA();
        }
    }
}

